/**
 * Simple Jquery Form Builder (SJFB)
 * Copyright (c) 2015 Brandon Hoover, Hoover Web Development LLC (http://bhoover.com)
 * http://bhoover.com/simple-jquery-form-builder/
 * SJFB may be freely distributed under the included MIT license (license.txt).
 */

$(function(){

    //If loading a saved form from your database, put the ID here. Example id is "1".
    var formID = '1';

    //Adds new field with animation
    $("#add-field a").click(function(event) {
        event.preventDefault();
        $(addField($(this).data('type'))).appendTo('#form-fields').hide().slideDown('fast');
        $('#form-fields').sortable();
    });

    //Removes fields and choices with animation
    $("#sjfb").on("click", ".delete", function() {
        if (confirm('Are you sure?')) {
            var $this = $(this);
            $this.parent().slideUp( "slow", function() {
                $this.parent().remove()
            });
        }
    });

    //Makes fields required
    $("#sjfb").on("click", ".toggle-required", function() {
        requiredField($(this));
    });

    //Makes choices selected
    $("#sjfb").on("click", ".toggle-selected", function() {
        selectedChoice($(this));
    });

    //Adds new choice to field with animation
    $("#sjfb").on("click", ".add-choice", function() {
        $(addChoice()).appendTo($(this).prev()).hide().slideDown('fast');
        $('.choices ul').sortable();
    });
	
	function create_fields_array(){
		var fields = [];
        $('.field').each(function() {

            var $this = $(this);

            //field type
            var fieldType = $this.data('type');

            //field label
            var fieldLabel = $this.find('.field-label').val();

            //field required
            var fieldReq = $this.hasClass('required') ? 1 : 0;

            //check if this field has choices
            if($this.find('.choices li').length >= 1) {

                var choices = [];

                $this.find('.choices li').each(function() {

                    var $thisChoice = $(this);

                    //choice label
                    var choiceLabel = $thisChoice.find('.choice-label').val();

                    //choice selected
                    var choiceSel = $thisChoice.hasClass('selected') ? 1 : 0;

                    choices.push({
                        label: choiceLabel,
                        sel: choiceSel
                    });

                });
            }

            fields.push({
                type: fieldType,
                label: fieldLabel,
                req: fieldReq,
                choices: choices
            });

        });
		return fields;
		
	}
	
	$("#sjfb").on("click", "#save_view", function() {
		url = $("#sjfb").data("action");
		view_url = $("#sjfb").data("view_url");
		var fields = [];
        var fields = create_fields_array();
        
        var frontEndFormHTML = '';


        var data = JSON.stringify([{"name":"formID","value":formID},{"name":"formFields","value":fields}]);
        $.ajax({
            method: "POST",
            url: url,
            data: data,
            dataType: 'json',
            complete: function (msg) {

                window.location = view_url
            }

        });
			
	})
	
    //Saving form
    $("#sjfb").submit(function(event) {
		url = $(this).data("action");
		
        event.preventDefault();
		var fields = [];
        var fields = create_fields_array();
        
        var frontEndFormHTML = '';


        var data = JSON.stringify([{"name":"formID","value":formID},{"name":"formFields","value":fields}]);
        $.ajax({
            method: "POST",
            url: url,
            data: data,
            dataType: 'json',
            complete: function (msg) {

                //window.location = "index.php?action=request_tabs"
            }

        });
    });

    //load saved form


});

//Add field to builder
function addField(fieldType) {

    var hasRequired, hasChoices;
    var includeRequiredHTML = '';
    var includeChoicesHTML = '';
	var question_type = ''

    switch (fieldType) {
        case 'text':
            hasRequired = false;
            hasChoices = false;
            break;
        case 'textarea':
            hasRequired = false;
            hasChoices = false;
            break;
        case 'select':
            hasRequired = false;
            hasChoices = true;
            break;
        case 'radio':
            hasRequired = false;
            hasChoices = true;
			question_type = "Single Select Option Quection"
			
            break;
        case 'checkbox':
            hasRequired = false;
            hasChoices = true;
			question_type = "Multi Select Option Quection"
            break;
        case 'agree':
            //required "agree to terms" checkbox
            hasRequired = false;
            hasChoices = false;
            break;
    }

    if (hasRequired) {
        includeRequiredHTML = '' +
            '<label>Required? ' +
            '<input class="toggle-required" type="checkbox">' +
            '</label>'
    }

    if (hasChoices) {
        includeChoicesHTML = '' +
            '<div class="choices">' +
            '<ul></ul>' +
            '<button type="button" class="add-choice">Add Option</button>' +
            '</div>'
    }

    return '' +
        '<div class="field" data-type="' + fieldType + '">' +
        '<button type="button"  class="delete">Delete Field</button>' +
        '<h3>' + question_type + '</h3>' +
        '<div class="row "><div class="col-md-12 "><div class="form-group"><label>Question:</label>' +
        '<input type="text" class="field-label form-control">' +
        includeRequiredHTML +
        includeChoicesHTML +
        '</div>'
}

//Make builder field required
function requiredField($this) {
    if (!$this.parents('.field').hasClass('required')) {
        //Field required
        $this.parents('.field').addClass('required');
        $this.attr('checked','checked');
    } else {
        //Field not required
        $this.parents('.field').removeClass('required');
        $this.removeAttr('checked');
    }
}

function selectedChoice($this) {
    if (! $this.parents('li').hasClass('selected')) {

        //Only checkboxes can have more than one item selected at a time
        //If this is not a checkbox group, unselect the choices before selecting
        if ($this.parents('.field').data('type') != 'checkbox') {
            $this.parents('.choices').find('li').removeClass('selected');
            $this.parents('.choices').find('.toggle-selected').not($this).removeAttr('checked');
        }

        //Make selected
        $this.parents('li').addClass('selected');
        $this.attr('checked','checked');

    } else {

        //Unselect
        $this.parents('li').removeClass('selected');
        $this.removeAttr('checked');

    }
}

//Builder HTML for select, radio, and checkbox choices
function addChoice() {
    return '' +
        '<li>' +
        '<label>Choice: ' +
        '<input type="text" class="choice-label">' +
        '</label>' +
        '<label>Correct! ' +
        '<input class="toggle-selected" type="checkbox">' +
        '</label>' +
        '<button type="button" class="delete">Delete Choice</button>' +
        '</li>'
}

//Loads a saved form from your database into the builder
function loadForm(formID) {
    $.getJSON(formID, function(data) {
        if (data) {
            //go through each saved field object and render the builder
            $.each( data, function( k, v ) {
                //Add the field
                $(addField(v['type'])).appendTo('#form-fields').hide().slideDown('fast');
                var $currentField = $('#form-fields .field').last();

                //Add the label
                $currentField.find('.field-label').val(v['label']);

                //Is it required?
                if (v['req']) {
                    requiredField($currentField.find('.toggle-required'));
                }

                //Any choices?
                if (v['choices']) {
                    $.each( v['choices'], function( k, v ) {
                        //add the choices
                        $currentField.find('.choices ul').append(addChoice());

                        //Add the label
                        $currentField.find('.choice-label').last().val(v['label']);

                        //Is it selected?
                        if (v['sel']) {
                            selectedChoice($currentField.find('.toggle-selected').last());
                        }
                    });
                }

            });

            $('#form-fields').sortable();
            $('.choices ul').sortable();
        }
    });
}