<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Complaints_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function getparentComplaints()
	{
		$this->db->select("s.*,p.father_name");
        $this->db->where('s.sender', "parent");
		$this->db->join('parents p', "p.PR_number = s.userid");
		$this->db->join('students std', "std.PR_number = p.PR_number");
		$this->db->where('std.branchid', $this->session->userdata('principal_branchid'));
        $query = $this->db->get('complaints s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getteacherComplaints(){
		$this->db->select("s.*,t.teacher_name");
        $this->db->where('s.sender', "teacher");
		$this->db->order_by('s.id', "desc");
		$this->db->join('teacher as t', "t.teacherid = s.userid");
		$this->db->where('t.branchid', $this->session->userdata('principal_branchid'));
        $query = $this->db->get('complaints s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}

	public function add($post)
	{
		$this->db->set($post);
        $this->db->insert("complaints");
        return $this->db->insert_id();
	}
	public function myteacherComplaints(){
		$this->db->select("s.*,t.teacher_name");
        $this->db->where('s.sender', "principal");
		$this->db->where('s.receiver', "teacher");
		$this->db->order_by('s.id', "desc");
		$this->db->join('teacher as t', "t.teacherid = s.userid");
		$this->db->where('t.branchid', $this->session->userdata('principal_branchid'));
        $query = $this->db->get('complaints s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function myparentsComplaints(){
		$this->db->select("s.*,std.name as student_name");
        $this->db->where('s.sender', "principal");
		$this->db->where('s.receiver', "parent");
		$this->db->order_by('s.id', "desc");
		$this->db->join('students std', "std.GR_number = s.userid");
		$this->db->where('std.branchid', $this->session->userdata('principal_branchid'));
        $query = $this->db->get('complaints s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getComplain($id)
	{
		$this->db->select('c.*');
		$this->db->where('c.id',$id);
		$query = $this->db->get('complaints c');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function update($post,$id)
	{
		$this->db->where("id",$id);
        $this->db->update('complaints',$post);
		return TRUE;
	}
	public function delete($id)
	{
		$this->db->where("id",$id);
        $this->db->delete('complaints');
		return TRUE;
	}
}

?>
