<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Teacher extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
	}

	// Frontend User CRUD
	public function index()
	{
		$crud = $this->generate_crud('teacher');
		$crud->columns(array('teacher_name','email','mobile','iqama'));
		$crud->set_relation('branchid','branches','branch_name');
		$crud->set_relation('classid','classes','class_name');
		$crud->set_relation('sectionid','sections','section_name');
		$crud->set_field_upload('picture', UPLOAD_PICTURES);
		$crud->field_type('reg_id', 'hidden');
		//$crud->set_relation('classid','classes','class_name');
		//$crud->set_relation('subjectid','subjects','subject_name');
		$crud->change_field_type('teacher_password','password');
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$this->mPageTitle = 'Teachers';
		$this->render_crud();
	}
}	