<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Student extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
	}

	// Frontend User CRUD
	public function index()
	{
		$crud = $this->generate_crud('students');
		$crud->columns(array('branchid','classid','sectionid','PR_number','GR_number','name','nationality'));
		//$crud->columns(array('name','nationality','classid'));
		$crud->set_field_upload('picture', UPLOAD_PICTURES);
		$crud->change_field_type('student_password','password');
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$crud->set_relation('branchid','branches','branch_name');
		//$crud->set_relation('classid','classes','class_name');
		$crud->set_relation('classid', 'classes', 'class_name');
		$crud->set_relation('sectionid', 'sections', 'section_name');
		//$crud->order_by('classid','ASC');
		
		$this->db->select('*');
		$querydata = $this->db->get('subjects')->result(); // to get whole table values

		$resultarray = array();  // defines a new array
		foreach ($querydata as $result) 
		{

			$resultarray[$result->subjectid] = $result->subject_name; //initializing table values to the array 

		}

		$crud->field_type('subject', 'multiselect', $resultarray);
		
		
		
		$this->mPageTitle = 'Students';
		$this->render_crud();
	}
}	