<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Notifications extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
	}

	// Frontend User CRUD
	public function index()
	{
		$crud = $this->generate_crud('notifications_admin');
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$crud->set_relation('aid','admin','name');
		//$crud->set_relation('sectionid','sections','section_name');
		//$crud->set_relation('subjectid','subjects','subject_name');
		//$crud->set_relation('teacherid','teacher','teacher_name');
		
		
		
		$this->mPageTitle = 'Notifications';
		$this->render_crud();
	}
	

public function admin()
	{
		
		//print_r($this->session->userdata);
		
		$crud = $this->generate_crud('notifications_admin');
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$crud->set_relation('aid','admin','name');
		$crud->display_as('aid','Admin');
		//$crud->unset_add_fields('sender', 'status');
		
		$crud->columns(array('aid','message','status','log'));
		//Sender
		$crud->callback_add_field('sender', function () {
		return $this->session->userdata('username') . '<input type="hidden" maxlength="50" value="'.$this->session->userdata('user_id').'" name="sender">';
		});
	
		$crud->callback_edit_field('sender', function () {
		return $this->session->userdata('username') . '<input type="hidden" maxlength="50" value="'.$this->session->userdata('user_id').'" name="sender">';
		});
	
		
		$this->mPageTitle = 'Notifications for Admin';
		$this->render_crud();
	}
	
public function principal()
	{
		$crud = $this->generate_crud('notifications_principal');
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$crud->set_relation('pid','principal','name');
		$crud->display_as('pid','Principal');

		
		$crud->columns(array('pid','message','status','log'));

		//Sender
		$crud->callback_add_field('sender', function () {
		return $this->session->userdata('username') . '<input type="hidden" maxlength="50" value="'.$this->session->userdata('user_id').'" name="sender">';
		});
	
		$crud->callback_edit_field('sender', function () {
		return $this->session->userdata('username') . '<input type="hidden" maxlength="50" value="'.$this->session->userdata('user_id').'" name="sender">';
		});
	
		
		$this->mPageTitle = 'Notifications for Principal';
		$this->render_crud();
	}
public function teacher()
	{
		$crud = $this->generate_crud('notifications_teacher');
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$crud->set_relation('teacherid','teacher','teacher_name');
		$crud->display_as('teacherid','Teacher');

		
		$crud->columns(array('teacherid','message','status','log'));

		//Sender
		$crud->callback_add_field('sender', function () {
		return $this->session->userdata('username') . '<input type="hidden" maxlength="50" value="'.$this->session->userdata('user_id').'" name="sender">';
		});
	
		$crud->callback_edit_field('sender', function () {
		return $this->session->userdata('username') . '<input type="hidden" maxlength="50" value="'.$this->session->userdata('user_id').'" name="sender">';
		});
	
		
		$this->mPageTitle = 'Notifications for Teacher';
		$this->render_crud();
	}

public function parents()
	{
		$crud = $this->generate_crud('notifications_parents');
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$crud->set_relation('ptid','parents','name');
		$crud->display_as('ptid','Parents');

		
		$crud->columns(array('ptid','message','status','log'));

		//Sender
		$crud->callback_add_field('sender', function () {
		return $this->session->userdata('username') . '<input type="hidden" maxlength="50" value="'.$this->session->userdata('user_id').'" name="sender">';
		});
	
		$crud->callback_edit_field('sender', function () {
		return $this->session->userdata('username') . '<input type="hidden" maxlength="50" value="'.$this->session->userdata('user_id').'" name="sender">';
		});
	
		
		$this->mPageTitle = 'Notifications for Parents';
		$this->render_crud();
	}
public function student()
	{
		$crud = $this->generate_crud('notifications_students');
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$crud->set_relation('stdid','students','name');
		$crud->display_as('stdid','Students');

		
		$crud->columns(array('stdid','message','status','log'));

		//Sender
		$crud->callback_add_field('sender', function () {
		return $this->session->userdata('username') . '<input type="hidden" maxlength="50" value="'.$this->session->userdata('user_id').'" name="sender">';
		});
	
		$crud->callback_edit_field('sender', function () {
		return $this->session->userdata('username') . '<input type="hidden" maxlength="50" value="'.$this->session->userdata('user_id').'" name="sender">';
		});
	
		
		$this->mPageTitle = 'Notifications for Students';
		$this->render_crud();
	}	
	
	
	
}