<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Exams extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
	}

	// Frontend User CRUD
	public function index()
	{
		$crud = $this->generate_crud('exams');
		$crud->columns(array('date','classid','sectionid','subjectid','description'));
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$crud->set_relation('classid','classes','class_name');
		$crud->set_relation('sectionid','sections','section_name');
		$crud->set_relation('subjectid','subjects','subject_name');
		//$crud->set_relation('teacherid','teacher','teacher_name');
		//$crud->unset_columns(array('teacherid'));
		$crud->field_type('teacherid', 'hidden');
		
		$this->mPageTitle = 'Exams';
		$this->render_crud();
	}
}	