<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Progress_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function getStudent($classid,$sectionid)
	{
		$this->db->select("s.GR_number,s.name,s.stdid")->from("students s");
		$this->db->where('s.classid',$classid);
		$this->db->where('s.sectionid',$sectionid);
		$this->db->where('s.branchid', $this->session->userdata('teacher_branchid'));
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getStudentreport($classid,$sectionid)
	{
		$this->db->select("s.GR_number,s.name,s.stdid,r.remarks,c.class_name,sec.section_name,r.id")->from("students s");
		$this->db->where('s.classid',$classid);
		$this->db->where('s.sectionid',$sectionid);
		$this->db->join('classes c','c.classid=s.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		$this->db->join('student_report r','r.GR_number=s.GR_number');
		$this->db->where('s.branchid', $this->session->userdata('teacher_branchid'));
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	
	public function getClassSection($teacherid,$classid)
	{
		$this->db->select("w.teacherid,w.classid,w.sectionid,w.subjectid,c.class_name,s.section_name,sb.subject_name")->from("weekly_timetable w");
		$this->db->where('w.teacherid',$teacherid);
		$this->db->where('w.classid',$classid);
		$this->db->distinct();
		$this->db->join('classes c','w.classid=c.classid');
		$this->db->join('sections s','s.sectionid=w.sectionid');
		$this->db->join('subjects sb','sb.subjectid=w.subjectid');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}

	public function add($post)
	{
		$post['date'] = date('Y-m-d');
		$this->db->set($post);
        $this->db->insert("student_report");
        return $this->db->insert_id();
	}
	public function getSubject($subjectid)
	{
		$this->db->where('subjectid',$subjectid);
		$query = $this->db->get('subjects');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getReport($id)
	{
		$this->db->select('GR_number,remarks');
		$this->db->where('id',$id);
		$query = $this->db->get('student_report');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function update($post,$id)
	{
		$this->db->set($post);
		$this->db->where('id',$id);
        $this->db->update("student_report");
	}
}

?>
