<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Substitute_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function getAbsentteacher(){
		$this->db->select("t.teacherid,t.teacher_name");
		$this->db->join('teacher as t', "t.teacherid = a.teacherid");
		$this->db->where('a.status', 'A');
		$this->db->where('a.date', date('Y-m-d'));
		$this->db->where('t.branchid', $this->session->userdata('principle_branchid'));
        $query = $this->db->get('teacher_attendance a');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getDayid()
	{
		$this->db->select("id");
		$this->db->where('d.name', date('l'));
        $query = $this->db->get('days d');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getTeacherstimetable($teacherid,$dayid)
	{
		$this->db->select("w.teacherid,w.id,w.classid,w.sectionid,w.subjectid,w.period_no,w.dayid,c.class_name,s.section_name,sb.subject_name");
		$this->db->from('weekly_timetable w');
		$this->db->where('w.dayid', $dayid);
		$this->db->where('w.teacherid', $teacherid);
		$this->db->where('w.free', 'N');
		$this->db->join('classes as c', "c.classid=w.classid");
		$this->db->join('sections as s', "s.sectionid=w.sectionid");
		$this->db->join('subjects as sb', "sb.subjectid=w.subjectid");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function getSelectedTeachers($weekly_id)
	{ 
		$this->db->select("w.teacherid as sub_teacherid,t.teacher_name");
		$this->db->join('teacher t','t.teacherid=w.teacherid');
		$this->db->where('w.date', date('Y-m-d'));
		$this->db->where('w.weekly_time_id', $weekly_id);
        $query = $this->db->get('substitute_teacher w');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}

	public function getfreeteahers($period,$dayid)
	{
		$this->db->select("w.teacherid,t.teacher_name,t.teacherid");
		$this->db->where('w.period_no', $period);
		$this->db->where('w.dayid', $dayid);
		$this->db->where('w.free', 'Y');
		$this->db->join('teacher as t', "t.teacherid = w.teacherid");
		$this->db->where('t.branchid', $this->session->userdata('principle_branchid'));
        $query = $this->db->get('weekly_timetable w');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function addsubstituteteacher($post)
	{
		// delete teacher
		$this->db->where('date', date('Y-m-d'));
		$this->db->where('weekly_time_id', $post['timetableid']);
        $this->db->delete('substitute_teacher');
		
		$data['teacherid'] = $post['teacherid'];
		$data['weekly_time_id'] = $post['timetableid'];
		$data['date'] = date('Y-m-d');
		$this->db->set($data);
        $this->db->insert('substitute_teacher');
        return $this->db->insert_id();
	}
}

?>
