<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Appointment_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function add($post)
	{
		$this->db->set($post);
        $this->db->insert("appointment");
        return $this->db->insert_id();
	}
	public function get_confirmation_date($parentid)
	{
		$this->db->select("confirmation_date");
        $this->db->where('parent_id', $parentid);
		$this->db->limit(1);
		$this->db->order_by('id', 'desc');
        $query = $this->db->get('appointment');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function get_appointments()
	{
		$this->db->select("a.*,p.father_name");
		$this->db->join('parents p', 'p.ptid=a.parent_id');
		$this->db->join('students std', "std.PR_number = p.PR_number");
		$this->db->where('std.branchid', $this->session->userdata('principle_branchid'));
		$this->db->distinct();
		$this->db->order_by('a.id', 'desc');
        $query = $this->db->get('appointment a');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function get_appointmentbyid($id)
	{
		$this->db->select("*");
        $this->db->where('id', $id);
        $query = $this->db->get('appointment');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function update($post,$id)
	{
		$this->db->where("id",$id);
        $this->db->update("appointment", $post);
	}
}

?>
