<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Online_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	function get_results(){
		$this->db->select("p.*,c.class_name,s.section_name");
		//$this->db->limit(25);
		$this->db->distinct();
		$this->db->group_by('p.classid,p.sectionid');
		$this->db->join('classes c','c.classid=p.classid');
		$this->db->join('sections s','s.sectionid=p.sectionid');
		$this->db->join('students std','std.gr_number=p.gr_number');
		$this->db->where('std.branchid',$this->session->userdata('principal_branchid'));
		
        $query = $this->db->get('online_results p');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function get_class_students($classid,$sectionid)
	{
		$this->db->select('p.*,s.name,c.class_name,ss.section_name');
		$this->db->where('p.classid',$classid);
		$this->db->where('p.sectionid',$sectionid);
		$this->db->where('s.branchid',$this->session->userdata('principal_branchid'));
		$this->db->join('students s','s.gr_number=p.gr_number');
		$this->db->join('classes c','c.classid=p.classid');
		$this->db->join('sections ss','ss.sectionid=p.sectionid');
        $query = $this->db->get('online_results p');
        if ($query->num_rows() > 0) 
		{
            return $query->result();
        } else 
		{
            return FALSE;
        }
	}
	function update($data,$id)
	{
		$this->db->where('id',$id);
        $this->db->set($data);
        $this->db->update('online_results');
        return $id;
	}
	function delete_results($classid, $sectionid)
	{
		$this->db->where('classid',$classid);
		$this->db->where('sectionid',$sectionid);
        $this->db->delete('online_results');
        return TRUE;
	}
	function delete_old_result($gr_number,$term)
	{
		$this->db->where('gr_number',$gr_number);
		$this->db->where('term',$term);
        $this->db->delete('online_results');
        return TRUE;
	}
	public function getStudentParentReg($stdid)
	{
		$this->db->select('p.reg_id,p.PR_number,s.name');
		$this->db->join('parents p','p.PR_number=s.PR_number');
		$this->db->where('s.GR_number',$stdid);
		$query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
			return $query->row_array();
        } else {
            return "";
        }
	}
}

?>
