<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Notice_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function add($post)
	{
		$post['branchid'] = $this->session->userdata('principal_branchid');
		$this->db->set($post);
        $this->db->insert("notices");
        return $this->db->insert_id();
	}

	public function getAllNotice($limit, $offset)
	{
		$this->db->select("*");
		$this->db->order_by('id','desc');
		$this->db->where('branchid',$this->session->userdata('principal_branchid'));
		$this->db->limit($limit);
		$this->db->offset($offset);
        $query = $this->db->get('notices');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getAllNoticeCount()
	{
		$this->db->select("*");
		$this->db->order_by('id','desc');
		$this->db->where('branchid',$this->session->userdata('principal_branchid'));
        $query = $this->db->get('notices');
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
	}
	
	
	public function get_notice_board()
	{
		$this->db->select("*");
		$this->db->where("type","parents");
		$this->db->order_by('id', 'desc');
		$this->db->limit(10);
        $query = $this->db->get('notices');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function get_noticebyid($id){
		$this->db->select("*");
		$this->db->where("id",$id);
        $query = $this->db->get('notices');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function update($post,$id)
	{
		$post['date'] = date('Y-m-d',  strtotime($post['date']));;
		$this->db->where("id",$id);
        $this->db->update("notices", $post);
	}
	public function delete($id)
	{
		$this->db->where("id",$id);
        $this->db->delete('notices');
	}
	public function parent_list($branchid)
	{
		$this->db->select('p.ptid as parentid,p.PR_number,p.father_name,p.reg_id');
		$this->db->join('students s','s.PR_number=p.PR_number');
		$this->db->where('s.branchid',$branchid);
		$query = $this->db->get('parents p');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function teachers_list($branchid)
	{
		$this->db->select('teacherid,teacher_name');
		$this->db->where('t.branchid',$branchid);
		$query = $this->db->get('teacher t');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function getParentDetail($pr_number)
	{
		$this->db->select('p.reg_id,p.PR_number');
		$this->db->where('p.PR_number',$pr_number);
		$query = $this->db->get('parents p');
        if ($query->num_rows() > 0) {
            $res = $query->row_array();
			return $res;
        } else {
            return "";
        }
	}
	public function getTeacherDetail($teacherid)
	{
		$this->db->select('t.reg_id');
		$this->db->where('t.teacherid',$teacherid);
		$query = $this->db->get('teacher t');
        if ($query->num_rows() > 0) {
            $res = $query->row_array();
			return $res;
        } else {
            return "";
        }
	}
}

?>
