<?php



defined('BASEPATH') OR exit('No direct script access allowed');



class Grading_model extends CI_Model {



    public function __construct() {

        parent::__construct();

    }
	
	
	public function add_subject($branch_id)
	{
	  $fksubject_id = $this->input->post("fksubject_id");
	 
	  foreach($fksubject_id as $subject_id)
	  {
		  $data_insrt = array(
						   "branch_id" => $branch_id,
						   "fkclass_id" => $this->input->post("fkclass_id"),
						   "fksubject_id" => $subject_id,
							 );	
							 
		  $this->db->insert("tbl_assign_subject" , $data_insrt);
		  
	  }
	}
	
	public function update_subject($branch_id , $class_id = "")
	{
	  $this->db->where("branch_id" , $branch_id);
	  $this->db->where("fkclass_id" , $class_id);
	  $this->db->delete("tbl_assign_subject");
	  
	  $fksubject_id = $this->input->post("fksubject_id");
	 
	  foreach($fksubject_id as $subject_id)
	  {
		  $data_insrt = array(
						   "branch_id" => $branch_id,
						   "fkclass_id" => $this->input->post("fkclass_id"),
						   "fksubject_id" => $subject_id,
							 );	
							 
		  $this->db->insert("tbl_assign_subject" , $data_insrt);
		  
	  }
	}
	
	public function get_classes_info()
	{
	   $this->db->select("*");
	   $this->db->from("tbl_assign_subject");
	   $this->db->join("classes" , "tbl_assign_subject.fkclass_id = classes.classid");
	   $this->db->group_by('tbl_assign_subject.fkclass_id');
	   $query = $this->db->get();
	   return $query->result_array();	
	}
	
	public function get_class_info($branch_id = "")
	{
	  $this->db->where("branchid" , $branch_id);
	  $query = $this->db->get("classes");
	  return $query->result_array();	
	}
	
	public function get_single_class_info($class_id)
	  {
		$this->db->where("classid" , $class_id);
		$query = $this->db->get("classes");
		return $query->row_array();  
	  }
	
	public function get_section_info($branch_id = "")
	{
	  $this->db->where("branchid" , $branch_id);
	  $query = $this->db->get("sections");
	  return $query->result_array();	
	}
	
	public function get_single_section_info($section_id)
	  {
		$this->db->where("sectionid" , $section_id);
		$query = $this->db->get("sections");
		return $query->row_array();  
	  }
	
	public function get_teacher_info($branch_id = "")
	{
	  $this->db->where("branchid" , $branch_id);
	  $query = $this->db->get("teacher");
	  return $query->result_array();	
	}
	
	public function get_assign_subject_info($branch_id = "" , $class_id = "")
	{
	  $this->db->where("branch_id" , $branch_id);
	  $this->db->where("fkclass_id" , $class_id);
	  $query = $this->db->get("tbl_assign_subject");
	  return $query->result_array();	
	}
	
	public function get_subject_info($branch_id = "")
	{
	  $this->db->select("*");
	  $query = $this->db->get("subjects");
	  return $query->result_array();	
	}
	
	public function get_assign_subject($branch_id = "" , $class_id = "")
	{
	  $this->db->where("tbl_assign_subject.branch_id" , $branch_id);
	  $this->db->where("tbl_assign_subject.fkclass_id" , $class_id);
	  $this->db->from("tbl_assign_subject");
	  $this->db->join("subjects" , "tbl_assign_subject.fksubject_id = subjects.subjectid");
	  $query = $this->db->get();
	  return $query->result_array();	
	}
	
	
	public function add_teacher($branch_id)
	{
	  
	  $data_insrt = array(
	                   "branch_id" => $branch_id,
					   "fkclass_id" => $this->input->post("fkclass_id"),
					   "fksection_id" => $this->input->post("fksection_id"),
					   "fkteacher_id" => $this->input->post("fkteacher_id"),
	                     );
	  $this->db->insert("tbl_assign_teacher" , $data_insrt);					 
	  	
	}
	
	public function update_teacher($pk_assign_tea_id , $branch_id)
	{
	  
	  $data_insrt = array(
	                   "branch_id" => $branch_id,
					   "fkclass_id" => $this->input->post("fkclass_id"),
					   "fksection_id" => $this->input->post("fksection_id"),
					   "fkteacher_id" => $this->input->post("fkteacher_id"),
	                     );
	  $this->db->where("pk_assign_tea_id" , $pk_assign_tea_id);
	  $this->db->update("tbl_assign_teacher" , $data_insrt);					 
	  	
	}
	
	public function get_teachers_info()
	{
	   $this->db->select("*");
	   $this->db->from("tbl_assign_teacher");
	   $this->db->join("classes" , "tbl_assign_teacher.fkclass_id = classes.classid");
	   $this->db->join("sections" , "tbl_assign_teacher.fksection_id = sections.sectionid");
	   $this->db->join("teacher" , "tbl_assign_teacher.fkteacher_id = teacher.teacherid");
	   $query = $this->db->get();
	   return $query->result_array();	
	}
	
	public function get_assign_teacher_info($pk_assign_tea_id)
	{
	  $this->db->where("pk_assign_tea_id" , $pk_assign_tea_id);
	  $query = $this->db->get("tbl_assign_teacher");
	  return $query->row_array();	
	}
	
	public function get_marks_month($student_id , $term , $month)
	{
	  $this->db->where('fkstudent_id' , $student_id);
	  $this->db->where('term' , $term);
	  $this->db->where('month' , $month);
	  $query = $this->db->get('tbl_add_marks');
	  return $query->result_array();
	  	
	}
	
	public function get_marks_first_month($student_id , $term)
	{
	  $this->db->where('fkstudent_id' , $student_id);
	  $this->db->where('term' , $term);
	  $this->db->where('month' , 1);
	  $query = $this->db->get('tbl_add_marks');
	  return $query->result_array();
	  	
	}
	
	public function get_marks_second_month($student_id , $term)
	{
	  $this->db->where('fkstudent_id' , $student_id);
	  $this->db->where('term' , $term);
	  $this->db->where('month' , 2);
	  $query = $this->db->get('tbl_add_marks');
	  return $query->result_array();
	  	
	}
	
	public function get_marks_third_month($student_id , $term)
	{
	  $this->db->where('fkstudent_id' , $student_id);
	  $this->db->where('term' , $term);
	  $this->db->where('month' , 3);
	  $query = $this->db->get('tbl_add_marks');
	  return $query->result_array();
	  	
	}
	
	public function get_marks_last_month($student_id , $term)
	{
	  $this->db->where('fkstudent_id' , $student_id);
	  $this->db->where('term' , $term);
	  $this->db->where('month' , 4);
	  $query = $this->db->get('tbl_add_marks');
	  return $query->result_array();
	  	
	}
	
	public function get_student($branch_id , $class_id , $section_id)
	{
	  $this->db->where("branchid" , $branch_id);
	  $this->db->where("classid" , $class_id);
	  $this->db->where("sectionid" , $section_id);
	  $query = $this->db->get("students");
	  return $query->result_array();	
	}
	
	public function get_student_info($student_id)
	{
	  $this->db->where("stdid" , $student_id);
	  $query = $this->db->get("students");
	  return $query->row_array();	
	}
	
}