<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Accountant_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function getClasses()
	{
		$this->db->select('c.*');
		$this->db->where('c.classid !=','');
        $query = $this->db->get('classes c');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function addMonthlyfee($post)
	{
		$this->db->set($post);
        $this->db->insert('fee_structure');
        return $this->db->insert_id();
	}
	public function updateMonthlyfee($post,$id)
	{
		$this->db->where('id', $id);
        $this->db->set($post);
        $this->db->update('fee_structure');
        return $id;
	}
	public function updateStudentfee($post,$id)
	{
		$this->db->where('id', $id);
        $this->db->set($post);
        $this->db->update('fee_history');
        return $id;
	}

	public function getMonthlyfee($id='')
	{
		$this->db->select('f.*,c.class_name');
		if($id)
		{
			$this->db->where('id',$id);
		}
		$this->db->join('classes c','f.classid=c.classid');
        $query = $this->db->get('fee_structure f');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getStudents()
	{
		$this->db->select('s.GR_number');
		$this->db->order_by('s.GR_number','ASC');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getStudentsinfo()
	{
		$this->db->select('s.GR_number,c.class_name,sec.section_name,s.name');
		$this->db->join('classes c','s.classid=c.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		$this->db->order_by('s.GR_number','ASC');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getStudentinfo($id)
	{
		$this->db->select('s.branchid,s.name,c.class_name');
		$this->db->where('s.GR_number',$id);
		$this->db->join('classes c','s.classid=c.classid');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return FALSE;
        }
	}
	
	public function addStudentfee($post)
	{
		$post['duedate'] = date('Y-m')."-1";
		$this->db->set($post);
        $this->db->insert('fee_history');
        return $this->db->insert_id();
	}
	public function getStudentfee($id='')
	{
		$this->db->select('h.*,c.class_name,s.name,sec.section_name,h.id as historyid');
		$this->db->join('students s','s.GR_number=h.GR_number');
		$this->db->join('classes c','s.classid=c.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		if($id)
		{
			$this->db->where('h.id',$id);
		}
        $query = $this->db->get('fee_history h');
        if ($query->num_rows() > 0) {
			if($id)
			{
				return $query->row();
			}
			else
			{
				return $query->result();
			}
            
        } else {
            return FALSE;
        }
	}
	public function pendingStudentFee($date,$gr_number)
	{
		$this->db->select('id');
		$this->db->where('GR_number',$gr_number);
		if($date)
		{
			$this->db->where('paydate',$date);
		}
		else {
			$this->db->like('paydate',date('Y-m'));
		}
		$query = $this->db->get('fee_history h');
		if ($query->num_rows() > 0) {
			return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getPreviousFee($limit,$offset)
	{
		$this->db->select('*');
		$this->db->limit($limit);
		$this->db->offset($offset);
		$query = $this->db->get('pending_fee');
		if ($query->num_rows() > 0) {
			return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getPreviousFeebyid($id)
	{
		$this->db->select('*');
		$this->db->where('id',$id);
		$query = $this->db->get('pending_fee');
		if ($query->num_rows() > 0) {
			return $query->row();
        } else {
            return FALSE;
        }
	}

	public function totalPreviousFee()
	{
		$this->db->select('*');
		$query = $this->db->get('pending_fee');
		if ($query->num_rows() > 0) {
			return $query->num_rows();
        } else {
            return FALSE;
        }
	}
	public function remove_data($id)
	{
		$this->db->where('id',$id);
		$this->db->delete('pending_fee');
	}
	public function updatePrevfee($post, $id)
	{
		$this->db->set('paid_amount',$post['paid_amount']);
		$this->db->where('id',$id);
		$this->db->update('pending_fee');
	}
}

?>
