<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Webservice_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function login($username, $password) {
			$this->db->select("*")->from('parents');
			$this->db->where('username', $username);
			$this->db->where('parent_password', $password);
			$query = $this->db->get(); 
			if ($query && $query->num_rows() == 1) {
				$user = $query->row();
				$user->type = 'parent';
			} else {
				$this->db->select("*")->from('teacher');
				$this->db->where('username', $username);
				$this->db->where('teacher_password', $password);
				$query = $this->db->get(); 
				if ($query && $query->num_rows() == 1) {
					$user = $query->row();
					$user->type = 'teacher';
				} else {
					$this->db->select("*")->from('principal');
					$this->db->where('username', $username);
					$this->db->where('principal_password', $password);
					$query = $this->db->get(); 
					if ($query && $query->num_rows() == 1) {
						$user = $query->row();
						if(!$user->picture)
						{
							$user->picture = 'no-image.png';
						}
						$user->picture = str_replace(" ","%20",base_url()."assets/uploads/pictures/".$user->picture);
						$user->detail = strip_slashes(preg_replace('~[\r\n\t]+~',"",strip_tags($user->detail)));
						if($user->user_type == 'Admin')
						{
							$user->type = 'admin';
						}
						else
						{
							$user->type = 'principal';
						}
					} else {
						$user = FALSE;
					}
				}
			}
		
       return $user;
    }
	public function get_students_by_pr($pr_number)
	{
		$this->db->select("stdid as student_id,name,Gr_number,iqama_no,iqama_expiry,license_no,license_expiry,passport_no,passport_expiry,branchid")->from("students");
        $this->db->where('PR_number', $pr_number);
		$query = $this->db->get();
        if ($query && $query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function get_students($classid,$sectionid,$branchid,$limit=0,$offst=0)
	{
		$this->db->select('GR_number,name,PR_number');
		if($classid !=0 && $sectionid !=0)
		{
			$this->db->where('classid',$classid);
			$this->db->where('sectionid',$sectionid);
		}
		$this->db->where('branchid', $branchid);
		if($limit != 0)
		{
			$this->db->limit($limit);
			$this->db->offset($offst);
		}
		
        $query = $this->db->get('students');
        if ($query->num_rows() > 0) 
		{
            return $query->result();
        } else 
		{
            return FALSE;
        }
	}
	function get_studentparent($classid,$sectionid,$branchid,$limit='',$offset='')
	{
		$this->db->select('s.stdid, s.GR_number,p.reg_id,s.PR_number, p.device_token');
		if($classid !=0 && $sectionid !=0)
		{
			$this->db->where('classid',$classid);
			$this->db->where('sectionid',$sectionid);
		}
		$this->db->where('s.branchid', $branchid);
		$this->db->join('parents p','p.PR_number=s.PR_number');
		if($limit != 0)
		{
			$this->db->limit($limit);
			$this->db->offset($offset);
		}
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) 
		{
            return $query->result();
        } else 
		{
            return FALSE;
        }
	}
	function get_all_students($branchid)
	{
		$this->db->select('s.stdid, s.GR_number, s.name,s.iqama_no, s.iqama_expiry,p.PR_number');
		$this->db->where('s.branchid', $branchid);
		$this->db->join('parents p','p.PR_number=s.PR_number');
		$query = $this->db->get('students s');
        if ($query->num_rows() > 0) 
		{
            return $query->result();
        } else 
		{
            return FALSE;
        }
	}

	public function get_online_results($gr_number)
	{
		$this->db->select("file as file_path,date as result_date,term")->from("online_results");
        $this->db->where('Gr_number', $gr_number);
		$this->db->order_by('id', 'desc');
		$query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getStudent($parent_id)
	{
		$this->db->select('s.pr_number,s.gr_number,s.name,s.stdid,c.class_name,s.sectionid,s.classid,s.GR_number');
		$this->db->where('s.PR_number', $parent_id);
		 $this->db->join('classes as c', 's.classid=c.classid');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getStudentDocExpiry($parent_id)
	{
		$this->db->select('s.name,s.iqama_no,s.iqama_expiry,s.license_no,s.license_expiry,s.passport_no,s.passport_expiry');
		$this->db->where('s.PR_number', $parent_id);
		 $this->db->join('classes as c', 's.classid=c.classid');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getTeacherDocExpiry($teacherid)
	{
		$this->db->select('t.iqama,t.iqama_expiry,t.passport_no,t.passport_expiry,t.contract_period,t.contract_period_expiry,t.driving_license,t.driving_license_expiry');
		$this->db->where('t.teacherid', $teacherid);
        $query = $this->db->get('teacher t');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function addStudentProgressReport($post)
	{
		$this->db->set($post);
        $this->db->insert("student_report");
        return $this->db->insert_id();
	}
	public function getTeacherExamsTimetable($teacherid)
	{
		$this->db->select("l.*,c.class_name,s.section_name,sb.subject_name")->from("exams as l");
        $this->db->where('l.teacherid', $teacherid);
		$this->db->join('classes as c', 'c.classid=l.classid');
		$this->db->join('sections as s', 's.sectionid=l.sectionid');
		$this->db->join('subjects as sb', 'sb.subjectid=l.subjectid');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function get_students_transport($studentid)
	{
		$this->db->select("d.driver_name,d.bus_no,s.description,d.phone_no");
		$this->db->join('drivers d','s.driverid=d.driverid');
        $this->db->where('s.GR_number', $studentid);
         $query = $this->db->get('student_transport s');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function addSuggestions($post)
	{
		$this->db->set($post);
        $this->db->insert("suggestions");
        return $this->db->insert_id();
	}
	public function addComplain($post)
	{
		$this->db->set($post);
        $this->db->insert("complaints");
        return $this->db->insert_id();
	}
	public function addAppointment($post)
	{
		$this->db->set($post);
        $this->db->insert("appointment");
        return $this->db->insert_id();
	}
	public function apppointment_receives($parentid)
	{
		$this->db->select("*");
        $this->db->where('parent_id', $parentid);
		$this->db->where('type', 'receive');
        $query = $this->db->get('appointment');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function myAppointments($parentid)
	{
		$this->db->select("*");
        $this->db->where('parent_id', $parentid);
		$this->db->where('type', 'sent');
        $query = $this->db->get('appointment');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	
	public function addLeaves($post)
	{
		$this->db->set($post);
        $this->db->insert("leaves");
        return $this->db->insert_id();
	}
	public function get_students_progress($studentid)
	{
		$this->db->select("s.*");
        $this->db->where('s.GR_number', $studentid);
        $query = $this->db->get('student_report s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function gethomeworktoday($classid,$sectionid)
	{
		$this->db->select("e.images,e.document,sb.subject_name as subject,e.submission,e.date,e.description")->from("homework as e");
		$this->db->where('e.status', 'Y');
		$this->db->where('e.classid', $classid);
		$this->db->where('e.sectionid', $sectionid);
		$this->db->join('classes s', 's.classid=e.classid');
		$this->db->join('subjects sb', 'sb.subjectid=e.subjectid');
		//$this->db->where('e.date', date('Y-m-d'));
		$this->db->order_by('e.id', 'desc');
		$query = $this->db->get();
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return FALSE;
		}
	}
	public function addMessageFromParents($post)
	{ 
        $this->db->where("studentid", $post['studentid']);
		$data['parent_reply]']= $post['parent_reply'];
        $update = $this->db->update("attendance", $post);
	}
	public function addMessageFromTeacher($post)
	{ 
        $this->db->where("teacherid", $post['teacherid']);
		$this->db->where("date", $post['date']);
		$data['teacher_reply]']= $post['teacher_reply'];
        $update = $this->db->update("teacher_attendance", $post);
	}
	public function getTodayStudentAttendance($id)
	{
		$this->db->select("a.status,a.message as teacher_message,a.parent_reply")->from("attendance as a");
        $this->db->where('a.studentid', $id);
		$this->db->where('a.date', date('Y-m-d'));
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getStudentAttendance($id)
	{
		$this->db->select("a.status")->from("attendance as a");
        $this->db->where('studentid', $id);
		//$this->db->where('date', date('Y-m-d'));
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getComplaintsForParents($pr_number)
	{
		$this->db->select("s.*");
        $this->db->where('s.userid', $pr_number);
		$this->db->where('s.receiver', "parent");
		$this->db->where('s.sender', "principle");
        $query = $this->db->get('complaints s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getComplaintsForTeacher($teacherid)
	{
		$this->db->select("s.*");
        $this->db->where('s.userid', $teacherid);
		$this->db->where('s.receiver', "teacher");
		$this->db->where('s.sender', "principle");
        $query = $this->db->get('complaints s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}

	public function getstudentProfile($gr_number)
	{
		$this->db->select('s.pr_number,s.gr_number,s.name,s.stdid,c.class_name,sec.section_name,s.picture');
		$this->db->where('s.GR_number', $gr_number);
		 $this->db->join('classes as c', 's.classid=c.classid');
		 $this->db->join('sections as sec', 'sec.sectionid=s.sectionid');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getTeacherProfile($teacherid)
	{
		$this->db->select('t.*');
		$this->db->where('t.teacherid', $teacherid);
        $query = $this->db->get('teacher t');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	
	public function getExams($studentid,$classid,$sectionid)
	{
		$this->db->select("e.*,s.stdid as studentid,sb.subject_name as subject")->from("exams as e");
        $this->db->where('s.stdid', $studentid);
		$this->db->where('e.classid', $classid);
		$this->db->where('e.sectionid', $sectionid);
		$this->db->join('students s', 's.classid=e.classid');
		$this->db->join('subjects sb', 'sb.subjectid=e.subjectid');
		//$this->db->where('date', date('Y-m-d'));
		$this->db->order_by('e.id', 'desc');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getParentNotice($branchid)
	{
		$this->db->select("*");
		$this->db->where("type","parents");
		$this->db->or_where("type","all");
		$this->db->where("branchid",$branchid);
		$this->db->order_by('id', 'desc');
        $query = $this->db->get('notices');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getTeacherNotice($branchid)
	{
		$this->db->select("*");
		$this->db->where("type","teacher");
		$this->db->or_where("type","all");
		$this->db->where("branchid",$branchid);
		$this->db->order_by('id', 'desc');
        $query = $this->db->get('notices');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function get_attendance_count($post)
	{
		$post['to_date'] = date('Y-m-d',strtotime($post['to_date'])) ;
		$post['from_date'] = date('Y-m-d',strtotime($post['from_date'])) ;
		$this->db->select("*")->from("attendance as a");
        $this->db->where('studentid', $post['studentid']);
		$this->db->where('date <=', $post['to_date']);
		$this->db->where('date >=', $post['from_date']);
		$this->db->where('status', 'A');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
		
	}
	public function gethomeworktofrom($post)
	{
		
		$this->db->select("*")->from("homework as h");
        $this->db->where('classid', $post['classid']);
		$this->db->where('sectionid', $post['sectionid']);
		
		if(isset($post['teacherid']))
		{
			$this->db->where('teacherid', $post['teacherid']);
		}
		if(isset($post['period']))
		{
			$this->db->where('period', $post['period']);
		}
		if(isset($post['from_date']) && isset($post['to_date']))
		{
			$post['to_date'] = date('Y-m-d',strtotime($post['to_date'])) ;
			$post['from_date'] = date('Y-m-d',strtotime($post['from_date'])) ;
			$this->db->where('date <=', $post['to_date']);
			$this->db->where('date >=', $post['from_date']);
		}
		else {
			$this->db->where('date', date('Y-m-d'));
		}
        $query = $this->db->get();
        if ($query->num_rows() > 0) 
		{
			if(isset($post['teacherid']))
			{
				$res = $query->row();
				if($res->images)
				{
					$res->images  = str_replace(" ","%20",base_url()."assets/homework/".$res->images);
				}
				
				 return $res;
			}
			else
			{
				$res = $query->result();
				foreach ($res as $home) 
				{
					if($home->images)
					{
						$home->images  = str_replace(" ","%20",base_url()."assets/homework/".$home->images);
					}
				}
				return $res;
			}
           
        } else {
            return "";
        }
	}
	
	public function get_students_ranking($studentid)
	{
		$this->db->select("s.*");
        $this->db->where('s.GR_number', $studentid);
        $query = $this->db->get('student_ranking s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function getStudentAttendHistory($studentid)
	{
		$this->db->select("a.*")->from("attendance as a");
        $this->db->where('studentid', $studentid);
		$this->db->order_by('id', 'desc');
        $query = $this->db->get();
        if ($query->num_rows() >  0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getStudentFeeHistory($gr_number)
	{
		$this->db->select("h.*,s.name,sec.section_name")->from("fee_history as h");
		$this->db->join('students as s','s.GR_number=h.GR_number');
		$this->db->join('sections as sec','sec.sectionid=s.sectionid');
		$this->db->where('h.GR_number',$gr_number);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function addTeacherleave($post)
	{
		$this->db->set($post);
        $this->db->insert("leaves");
        return $this->db->insert_id();
	}
	public function getTeacherleave($userid)
	{
		$this->db->select("l.*")->from("leaves as l");
		$this->db->where('l.userid',$userid);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getTimetable($dayid,$teacherid,$period)
	{
		$this->db->select("t.*, c.class_name,s.section_name,sb.subject_name")->from("weekly_timetable as t");
        $this->db->where('t.teacherid', $teacherid);
		$this->db->where('t.dayid', $dayid);
		if($period)
		{
			$this->db->where('t.period_no', $period);
		}
		$this->db->join('classes as c', 'c.classid=t.classid');
		$this->db->join('sections as s', 's.sectionid=t.sectionid');
		$this->db->join('subjects as sb', 'sb.subjectid=t.subjectid');
		//$this->db->where('l.datetime',date('Y-m-d'));
		$this->db->order_by('t.period_no', 'ASC');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
			if($period)
			{
				return $query->row();
			}
			else{
				return $query->result();
			}
           
        } else {
            return array();
        }
	}
	function addhomework($post)
	{
		$this->db->where('teacherid', $post['teacherid']);
		$this->db->where('date', $post['date']);
		$this->db->where('classid', $post['classid']);
		$this->db->where('sectionid', $post['sectionid']);
		$this->db->where('subjectid', $post['subjectid']);
		$this->db->where('period', $post['period']);
        $this->db->delete('homework');
		
		$this->db->set($post);
        $this->db->insert("homework");
        return $this->db->insert_id();
	}
	public function getClassStudents($classid,$sectionid,$period,$subjectid)
	{
		$this->db->select("*")->from("students");
        $this->db->where('classid', $classid);
		$this->db->where('sectionid', $sectionid);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $students = $query->result();
			if($students)
			{ 
				foreach ($students as$key=> $t) 
				{ 
					$this->db->select("status,message")->from("attendance");
					$this->db->where('date',date('Y-m-d'));
					$this->db->where('studentid',$t->stdid);
					$this->db->where('classid',$classid);
					$this->db->where('sectionid',$sectionid);
					$this->db->where('period_no',$period);
					$this->db->where('subjectid',$subjectid);
					$query = $this->db->get();
					if ($query->num_rows() > 0) {
						$attend = $query->row();
					} else {
						$attend = '';
					}
					$t->attendance = $attend;
					$t->absent_count = $this->countAttendance(date('Y-m-d'),'A',$classid,$sectionid,$period);
					$t->present_count = $this->countAttendance(date('Y-m-d'),'P',$classid,$sectionid,$period);
					$t->bunk_count = $this->countAttendance(date('Y-m-d'),'B',$classid,$sectionid,$period);
				}
				return $students;
			}
        } else {
            return FALSE;
        }
	}
	public function countAttendance($date,$type,$classid,$sectionid,$period)
	{
		$this->db->select("a.id")->from("attendance a");
		$this->db->where('a.date',$date);
		$this->db->where('a.status',$type);
		$this->db->where('a.classid',$classid);
		$this->db->where('a.sectionid',$sectionid);
		$this->db->where('a.period_no',$period);
		 $query = $this->db->get();
		if ($query->num_rows() > 0) {
			return $query->num_rows();
		} else {
			return 0;
		}
	}
	public function Addattendance($post)
	{
		$this->db->where('period_no', $post['period_no']);
		$this->db->where('date', $post['date']);
		///$this->db->where('teacherid', $post['teacherid']);
		$this->db->where('classid', $post['classid']);
		$this->db->where('sectionid', $post['sectionid']);
		$this->db->where('subjectid', $post['subjectid']);
		$this->db->where('studentid', $post['studentid']);
        $this->db->delete('attendance');
		
		if($post['status'])
		{
			$this->db->set($post);
			$this->db->insert("attendance");
			return $this->db->insert_id();
		}
	}
	public function teacherhomework($teacherid)
	{
		$this->db->select("l.*,c.class_name,s.section_name,sb.subject_name")->from("homework as l");
        $this->db->where('l.teacherid', $teacherid);
		$this->db->join('classes as c', 'c.classid=l.classid');
		$this->db->join('sections as s', 's.sectionid=l.sectionid');
		$this->db->join('subjects as sb', 'sb.subjectid=l.subjectid');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getClassNote($classid,$sectionid,$period,$date,$teacherid)
	{
		$this->db->where('classid',$classid);
		$this->db->where('sectionid',$sectionid);
		$this->db->where('period_no',$period);
		$this->db->where('date',$date);
		$this->db->where('teacherid',$teacherid);
		$this->db->select("class_note,what_done");
		$query = $this->db->get('class_feedback');
		if ($query->num_rows() > 0) {
			$result = $query->row();
		} else {
			$result = FALSE;
		}
		return $result;
	}
	public function teacherOfmonths($branchid)
	{
		$this->db->select('m.*,t.teacher_name,n.name as month_name');
		$this->db->join('teacher t', 't.teacherid=m.userid');
		$this->db->join('months n', 'n.id=m.month');
		$this->db->where('t.branchid', $branchid);
		$this->db->where('m.type', 'teacher');
        $query = $this->db->get('userofmonth m');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function studentOfmonths($branchid)
	{
		$this->db->select('m.*,s.name,s.GR_number,n.name as month_name,c.class_name,sec.section_name');
		$this->db->join('students s', 's.GR_number=m.userid');
		$this->db->join('months n', 'n.id=m.month');
		$this->db->join('classes c','c.classid=s.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		$this->db->where('s.branchid', $branchid);
		$this->db->where('m.type', 'student');
		$this->db->order_by('n.id','ASC');
        $query = $this->db->get('userofmonth m');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function get_wtimetable($teacherid)
	{
		$this->db->select("dayid,d.name as dayname");
        $this->db->where('w.teacherid', $teacherid);
		$this->db->join('days as d', 'w.dayid=d.id');
         $query = $this->db->get('weekly_timetable w');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function get_wtimetablebyday($dayid, $teacherid)
	{
		$this->db->select("l.*,c.class_name,s.section_name,sb.subject_name");
        $this->db->where('teacherid', $teacherid);
		$this->db->where('dayid', $dayid);
		$this->db->order_by('period_no', 'ASC');
		$this->db->join('classes as c', 'c.classid=l.classid');
		$this->db->join('sections as s', 's.sectionid=l.sectionid');
		$this->db->join('subjects as sb', 'sb.subjectid=l.subjectid');
         $query = $this->db->get('weekly_timetable as l');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getduty($teacherid)
	{
		$this->db->select('d.name as duty_name,a.name as area_name,t.*,tt.teacher_name');
		$this->db->where('t.teacherid', $teacherid);
		$this->db->join('teacher as tt', 'tt.teacherid=t.teacherid');
		$this->db->join('extra_duties as d', 'd.id=t.duty_id');
		$this->db->join('extra_duties_area as a', 'a.id=t.area_id');
        $query = $this->db->get('teacher_duties t');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getTeacherMonthAbsents($teacherid)
	{
		$this->db->select("count(*) as total_attendance")->from("teacher_attendance");
        $this->db->where('teacherid', $teacherid);
		$this->db->where('status', 'A');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getTeacherAttendance($teacherid)
	{
		$this->db->select("*")->from("teacher_attendance");
        $this->db->where('teacherid', $teacherid);
		$this->db->where('date',date('Y-m-d'));
		$this->db->order_by('id', 'desc');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getAttendanceHistory($teacherid)
	{
		$this->db->select("a.*")->from("teacher_attendance as a");
        $this->db->where('a.teacherid', $teacherid);
		$this->db->order_by('a.id', 'desc');
		$this->db->limit(20);
        $query = $this->db->get();
        if ($query->num_rows() >  0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function today_subtimetable($teacherid)
	{
		$this->db->select("st.teacherid,c.class_name,s.section_name,sb.subject_name,wt.classid,wt.sectionid,wt.subjectid,wt.period_no,wt.start_time,wt.end_time")->from("substitute_teacher as st");
        $this->db->where('st.teacherid', $teacherid);
		$this->db->where('st.date',date('Y-m-d'));
		$this->db->join('weekly_timetable as wt', 'wt.id=st.weekly_time_id');
		
		//$this->db->join('teachers as t', 'st.teacherid=t.teacherid');
		$this->db->join('classes as c', 'c.classid=wt.classid');
		$this->db->join('sections as s', 's.sectionid=wt.sectionid');
		$this->db->join('subjects as sb', 'sb.subjectid=wt.subjectid');
		$query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array();
        }
	}
	public function getLessoninfo($teacherid,$subjectid){
		$this->db->select("l.description as lesson,l.id as lessonid")->from("lesson_plan as l");
        $this->db->where('l.teacherid', $teacherid);
		$this->db->where('l.datetime',date('Y-m-d'));
		$this->db->where('l.subjectid',$subjectid);
		$query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getClassinfo($teacherid,$period,$classid,$sectionid){
		$this->db->select("c.class_note,c.what_done")->from("class_feedback as c");
        $this->db->where('c.teacherid', $teacherid);
		$this->db->where('c.period_no',$period);
		$this->db->where('c.date',date('Y-m-d'));
		$query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getClassAttendance($teacherid,$classid,$sectionid,$period,$subjectid,$date='')
	{
		$this->db->select("*")->from("attendance");
        $this->db->where('teacherid', $teacherid);
		$this->db->where('classid', $classid);
		$this->db->where('sectionid', $sectionid);
		$this->db->where('period_no', $period);
		$this->db->where('subjectid', $subjectid);
		if($date)
		{
			$this->db->where('date', $date);
		}
        $query = $this->db->get();
        if ($query->num_rows() >  0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getClassHomework($teacherid,$classid,$sectionid,$period,$subjectid,$date='')
	{
		$this->db->select("*")->from("homework");
        $this->db->where('teacherid', $teacherid);
		$this->db->where('classid', $classid);
		$this->db->where('sectionid', $sectionid);
		$this->db->where('period', $period);
		$this->db->where('subjectid', $subjectid);
		if($date)
		{
			$this->db->where('date', $date);
		}
        $query = $this->db->get();
        if ($query->num_rows() >  0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getTeacherabsentCount($post)
	{
		$post['to_date'] = date('Y-m-d',strtotime($post['to_date'])) ;
		$post['from_date'] = date('Y-m-d',strtotime($post['from_date'])) ;
		$this->db->select("*")->from("teacher_attendance as a");
        $this->db->where('teacherid', $post['teacherid']);
		$this->db->where('date <=', $post['to_date']);
		$this->db->where('date >=', $post['from_date']);
		$this->db->where('status', 'A');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
		
	}
	public function getparentComplaints($branchid)
	{
		$this->db->select("s.*,p.father_name");
        $this->db->where('s.sender', "parent");
		$this->db->join('parents p', "p.PR_number = s.userid");
		$this->db->join('students std', "std.PR_number = p.PR_number");
		$this->db->where('std.branchid',$branchid);
        $query = $this->db->get('complaints s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function getteacherComplaints($branchid){
		$this->db->select("s.*,t.teacher_name");
        $this->db->where('s.sender', "teacher");
		$this->db->order_by('s.id', "desc");
		$this->db->join('teacher as t', "t.teacherid = s.userid");
		$this->db->where('t.branchid', $branchid);
        $query = $this->db->get('complaints s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function myteacherComplaints($branchid){
		$this->db->select("s.*,t.teacher_name");
        $this->db->where('s.sender', "principle");
		$this->db->where('s.receiver', "teacher");
		$this->db->order_by('s.id', "desc");
		$this->db->join('teacher as t', "t.teacherid = s.userid");
		$this->db->where('t.branchid', $branchid);
		$this->db->limit(20);
        $query = $this->db->get('complaints s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function myparentsComplaints($branchid){
		$this->db->select("s.*,p.father_name");
        $this->db->where('s.sender', "principle");
		$this->db->where('s.receiver', "parent");
		$this->db->order_by('s.id', "desc");
		$this->db->join('parents p', "p.PR_number = s.userid");
		$this->db->join('students std', "std.PR_number = p.PR_number");
		$this->db->where('std.branchid',$branchid);
		$this->db->limit(20);
        $query = $this->db->get('complaints s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function getAllTeachersAttendanceHistory($branchid,$date='')
	{
		if($date)
		{
			$this->db->select("t.teacher_name,t.teacherid")->from("teacher t");
			$this->db->where('t.branchid', $branchid);
			$query = $this->db->get();
			if ($query->num_rows() > 0) {
				$teachers = $query->result();
			} else {
				$teachers = FALSE;
			}
			if($teachers)
			{
				foreach ($teachers as$key=> $t) 
				{ 
					$this->db->select("*")->from("teacher_attendance");
					$this->db->where('date',$date);
					$this->db->where('teacherid',$t->teacherid);
					$query = $this->db->get();
					if ($query->num_rows() > 0) {
						$attend = $query->row();
					} else {
						$attend = FALSE;
					}
					$t->attendance = $attend;
				}
			}
			return $teachers;
		}
		else{
			$this->db->select("a.date")->from("teacher_attendance a");
			$this->db->join('teacher t','t.teacherid=a.teacherid');
			$this->db->where('t.branchid', $branchid);
			$this->db->limit(30);
			$this->db->distinct();
			$this->db->group_by('a.date');
			$this->db->order_by('a.id','desc');
			 $query = $this->db->get();
			if ($query->num_rows() > 0) {
				return $query->result();
			} else {
				return FALSE;
			}
		}
	}
	public function getStudentAbsentCont($branchid)
	{
		$this->db->select("*")->from("attendance as a");
		$this->db->where('a.date', date('Y-m-d'));
		$this->db->where('a.status', 'A');
		$this->db->join("teacher t","t.teacherid=a.teacherid");
		$this->db->join("students s","s.stdid=a.studentid");
		$this->db->join("classes c","c.classid=s.classid");
		$this->db->join("sections sec","sec.sectionid=s.sectionid");
		$this->db->distinct();
		$this->db->group_by("s.GR_number","ASC");
		$this->db->order_by("c.class_name","ASC");
		$this->db->order_by("sec.section_name","ASC");
		$this->db->where('t.branchid', $branchid);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
	}
	public function getTeacherAbsentCont($branchid)
	{
		$this->db->select("a.*")->from("teacher_attendance as a");
		$this->db->join("teacher t","t.teacherid=a.teacherid");
		$this->db->where('t.branchid', $branchid);
		$this->db->where('a.date', date('Y-m-d'));
		$this->db->where('a.status', 'A');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        } else {
            return 0;
        }
	}
	public function getTodayAbsentTeachers($branchid,$teacherid)
	{
		$this->db->select("a.status,t.teacher_name,t.teacherid")->from("teacher_attendance as a");
		$this->db->join('teacher t','t.teacherid=a.teacherid');
		$this->db->where('t.branchid', $branchid);
		if($teacherid)
		{
			$this->db->where('t.teacherid', $teacherid);
		}
		$this->db->where('date', date('Y-m-d'));
		$this->db->where('status', 'A');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function getTodayAbsentStudents($branchid)
	{
		$this->db->select("a.status,s.name,s.GR_number")->from("attendance as a");
		$this->db->join('students s','s.stdid=a.studentid');
		$this->db->where('a.date', date('Y-m-d'));
		$this->db->where('s.branchid', $branchid);
		$this->db->where('a.status', 'A');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function getAbsentteacher(){
		$this->db->select("t.teacherid,t.teacher_name");
		$this->db->join('teacher as t', "t.teacherid = a.teacherid");
		$this->db->where('a.status', 'A');
		$this->db->where('a.date', date('Y-m-d'));
        $query = $this->db->get(' teacher_attendance a');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getDayid()
	{
		$this->db->select("id");
		$this->db->where('d.name', date('l'));
        $query = $this->db->get('days d');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getTeacherstimetable($teacherid,$dayid)
	{
		$this->db->select("w.teacherid,w.id,w.classid,w.sectionid,w.subjectid,w.period_no,w.dayid,c.class_name,s.section_name,sb.subject_name");
		$this->db->from('weekly_timetable w');
		$this->db->where('w.dayid', $dayid);
		$this->db->where('w.teacherid', $teacherid);
		$this->db->where('w.free', 'N');
		$this->db->join('classes as c', "c.classid=w.classid");
		$this->db->join('sections as s', "s.sectionid=w.sectionid");
		$this->db->join('subjects as sb', "sb.subjectid=w.subjectid");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array();
        }
	}
	function getSelectedTeachers($weekly_id)
	{ 
		$this->db->select("w.teacherid as sub_teacherid,t.teacher_name");
		$this->db->join('teacher t','t.teacherid=w.teacherid');
		$this->db->where('w.date', date('Y-m-d'));
		$this->db->where('w.weekly_time_id', $weekly_id);
        $query = $this->db->get('substitute_teacher w');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getfreeteahers($period,$dayid,$branchid)
	{
		$this->db->select("w.teacherid,t.teacher_name,t.teacherid");
		$this->db->where('w.period_no', $period);
		$this->db->where('w.dayid', $dayid);
		$this->db->where('w.free', 'Y');
		$this->db->where('t.branchid', $branchid);
		$this->db->join('teacher as t', "t.teacherid = w.teacherid");
        $query = $this->db->get('weekly_timetable w');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getPrincipleProfile($id)
	{
		$this->db->select('*');
		$this->db->where('id', $id);
        $query = $this->db->get('principal');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getFeeDefaulters($branchid,$classid,$sectionid)
	{
		$this->db->select('f.*,s.name,s.stdid,c.class_name,sec.section_name');
		$this->db->where('s.branchid', $branchid);
		$this->db->where('s.classid', $classid);
		$this->db->where('s.sectionid', $sectionid);
		$this->db->join('students s','s.GR_number=f.GR_number');
		
		$this->db->join('classes c','s.classid=c.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
        $query = $this->db->get('fee_history f');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function addsubstituteteacher($post)
	{
		// delete teacher
		$this->db->where('date', date('Y-m-d'));
		$this->db->where('weekly_time_id', $post['timetableid']);
        $this->db->delete('substitute_teacher');
		
		$data['teacherid'] = $post['teacherid'];
		$data['weekly_time_id'] = $post['timetableid'];
		$data['date'] = date('Y-m-d');
		$this->db->set($data);
        $this->db->insert('substitute_teacher');
        return $this->db->insert_id();
	}
	public function pendinghomework($branchid,$date='')
	{
		$this->db->select("l.*,c.class_name,s.section_name,sb.subject_name,t.teacher_name,l.date")->from("homework as l");
        $this->db->where('l.status', 'N');
		if($date)
		{
			$this->db->where('l.date',$date);
		}
		
		$this->db->join('classes as c', 'c.classid=l.classid');
		$this->db->join('sections as s', 's.sectionid=l.sectionid');
		$this->db->join('subjects as sb', 'sb.subjectid=l.subjectid');
		$this->db->join('teacher as t', 't.teacherid=l.teacherid');
		$this->db->order_by('l.id','desc');
		$this->db->where('t.branchid',$branchid);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function deletehomework($post)
	{
		$this->db->where('teacherid', $post['teacherid']);
		$this->db->where('date', $post['date']);
		$this->db->where('classid', $post['classid']);
		$this->db->where('sectionid', $post['sectionid']);
		$this->db->where('subjectid', $post['subjectid']);
		$this->db->where('period', $post['period']);
        $this->db->delete('homework');
	}
	public function getAllNotice($branchid)
	{
		$this->db->select("*");
		$this->db->order_by('id','desc');
		$this->db->where('branchid',$branchid);
        $query = $this->db->get('notices');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function approveHomework($post)
	{
		$this->db->where('teacherid', $post['teacherid']);
		$this->db->where('date', $post['date']);
		$this->db->where('classid', $post['classid']);
		$this->db->where('sectionid', $post['sectionid']);
		$this->db->where('subjectid', $post['subjectid']);
		$this->db->where('period', $post['period']);
		$this->db->update("homework", $post);
	}
	function addNotice($post)
	{
		$this->db->set($post);
		$this->db->insert("notices");
        return $this->db->insert_id();
	}
	function updateNotice($post,$notice_id)
	{
		$this->db->where('id', $notice_id);
		$this->db->update("notices", $post);
	}
	function deletenotice($noticeid)
	{
		$this->db->where('id',$noticeid);
		$this->db->delete('notices');
	}
	function get_branch_name($branchid)
	{
		$this->db->select('branch_name');
		$this->db->where('branchid',$branchid);
		$query = $this->db->get('branches');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	function lastNotice($branchid)
	{
		$this->db->select('title,description,date,type');
		$this->db->where('branchid',$branchid);
		$this->db->limit(1);
		$this->db->order_by('id', 'desc');
		$query = $this->db->get('notices');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return "";
        }
	}
	public function teachersTodayAttendance($branchid,$date)
	{
		$this->db->select("t.*")->from("teacher t");
		$this->db->where('t.branchid', $branchid);
		//$this->db->join('classes c', 'c.classid=t.classid');
		//$this->db->join('sections s', 's.sectionid=t.sectionid');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $teachers = $query->result();
			if($teachers)
			{
				if(!$date)
				{
					$date = date('Y-m-d');
				}
				foreach ($teachers as$key=> $t) 
				{ 
					$this->db->select("*")->from("teacher_attendance");
					$this->db->where('date',$date);
					$this->db->where('teacherid',$t->teacherid);
					$query = $this->db->get();
					if ($query->num_rows() > 0) {
						$attend = $query->row();
						$status = $attend->status;
					} else {
						$attend = "";
						$status = "";
					}
					$t->attendance = $status;
					$t->detail = strip_slashes(preg_replace('~[\r\n\t]+~',"",strip_tags($t->detail)));
				}
			}
			return $teachers;
        } else {
            return "";
        }
	}
	public function get_leaves($branchid)
	{
		$this->db->select("l.*,t.teacher_name");
        $this->db->where('l.sender', "teacher");
		$this->db->join('teacher t', "t.teacherid = l.userid");
		$this->db->where('t.branchid', $branchid);
		$this->db->order_by('id', 'desc');
        $query = $this->db->get('leaves l');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function approveLeaves($id,$status)
	{
		$this->db->set('status',$status);
		$this->db->where('id',$id);
        $this->db->update("leaves");
	}
	public function getPrincipalDocExpiry($principalid)
	{
		$this->db->select('t.iqama,t.iqama_expiry,t.passport_no,t.passport_expiry');
		$this->db->where('t.id', $principalid);
        $query = $this->db->get('principal t');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function teacherOfmonth($branchid)
	{
		$this->db->select('m.*,t.teacher_name,n.name as month_name,t.picture');
		$this->db->join('teacher t', 't.teacherid=m.userid');
		$this->db->where('t.branchid', $branchid);
		$this->db->join('months n', 'n.id=m.month');
		$this->db->where('m.type', 'teacher');
        $query = $this->db->get('userofmonth m');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function markTeacherAttendance($post)
	{
		$this->db->where('date',date('Y-m-d'));
		$this->db->where('teacherid',$post['teacherid']);
		$this->db->delete('teacher_attendance');
		
		//add teacher attendance
		$post['date'] = date('Y-m-d');
		$this->db->set($post);
        $this->db->insert("teacher_attendance");
        return $this->db->insert_id();
	}
	public function getParentTeacherLastNotice($branchid,$type)
	{
		$this->db->select('*');
		$this->db->where('type',$type);
		$this->db->where('branchid',$branchid);
		$this->db->order_by('id', 'desc');
		$query = $this->db->get('notices');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return "";
        }
	}
	public function getAppointmentsfromPrincipal($branchid)
	{
		$this->db->select("a.*,p.father_name,class_name,sec.section_name");
		$this->db->join('parents p', 'p.ptid=a.parent_id');
		$this->db->join('students std', "std.PR_number = p.PR_number");
		$this->db->join('classes c', "c.classid=std.classid");
		$this->db->join('sections sec', "sec.sectionid=std.sectionid");
		$this->db->where('a.type','sent');
		$this->db->where('std.branchid', $branchid);
		$this->db->order_by('a.id', 'desc');
        $query = $this->db->get('appointment a');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getAppoinmentsfromParents($branchid)
	{
		$this->db->select("a.*,p.father_name");
		$this->db->join('parents p', 'p.ptid=a.parent_id');
		$this->db->join('students std', "std.PR_number = p.PR_number");
		$this->db->where('std.branchid', $branchid);
		$this->db->where('a.type','receive');
		$this->db->where('a.confirmation_date','0000-00-00 00:00:00');
		$this->db->order_by('a.id', 'desc');
        $query = $this->db->get('appointment a');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function confirmAppointment($date,$id)
	{
		$this->db->set('confirmation_date',$date);
		$this->db->where('id',$id);
		$res = $this->db->update("appointment");
		return $res;
	}
	public function addAppointmentbyPrincipal($post)
	{
		$this->db->set($post);
        $this->db->insert("appointment");
        return $this->db->insert_id();
	}
	public function addComplainbyPrincipal($post)
	{
		$this->db->set($post);
        $this->db->insert("complaints");
        return $this->db->insert_id();
	}

	public function getStdAttendance($class='',$section='',$period='',$date='',$branchid)
	{
		if($date)
		{
			$this->db->select("s.name,s.stdid,c.class_name,sec.section_name,s.classid,sec.sectionid")->from("students s");
			//$this->db->limit(30);
			$this->db->where('s.classid',$class);
			$this->db->where('s.sectionid',$section);
			$this->db->join('classes c','c.classid=s.classid');
			$this->db->join('sections sec','sec.sectionid=s.sectionid');
			$this->db->where('s.branchid', $branchid);
			$query = $this->db->get();
			if ($query->num_rows() > 0) {
				$students = $query->result();
			} else {
				$students = FALSE;
			}
			if($students)
			{
				foreach ($students as$key=> $t) 
				{ 
					$this->db->select("status,date,period_no,message,subjectid,teacherid")->from("attendance");
					$this->db->where('date',$date);
					$this->db->where('studentid',$t->stdid);
					$this->db->where('classid',$class);
					$this->db->where('sectionid',$section);
					$this->db->where('period_no',$period);
					$query = $this->db->get();
					if ($query->num_rows() > 0) {
						$attend = $query->row();
					} else {
						$attend = FALSE;
					}
					$t->attendance = $attend;
				}
			}
			return $students;
		}
		else{
			$this->db->select("a.*,c.class_name,sec.section_name,sb.subject_name,t.teacher_name")->from("attendance a");
			//$this->db->limit(30);
			$this->db->join('students s','s.stdid=a.studentid');
			$this->db->join('classes c','c.classid=s.classid');
			$this->db->join('sections sec','sec.sectionid=s.sectionid');
			$this->db->join('subjects sb','sb.subjectid=a.subjectid');
			$this->db->join('teacher t','t.teacherid=a.teacherid');
			$this->db->where('t.branchid', $this->session->userdata('principle_branchid'));
			$this->db->distinct();
			$this->db->group_by('a.date');
			$this->db->order_by('a.id','desc');
			 $query = $this->db->get();
			if ($query->num_rows() > 0) {
				return $query->result();
			} else {
				return FALSE;
			}
		}
	}
	function getTodayAbsentStd($branchid, $date)
	{
		$this->db->select("s.name,s.stdid,c.class_name,sec.section_name,s.classid,sec.sectionid,a.parent_reply");
		$this->db->where('a.date',$date);
		$this->db->where('a.status','A');
		$this->db->where('s.branchid',$branchid);
		$this->db->join('students s','s.stdid=a.studentid');
		$this->db->join('classes c','c.classid=s.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		$query = $this->db->get('attendance a');
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			$students = "";
		}
	}
	function lateComingStudents($branchid, $date)
	{
		$this->db->select("s.name,s.stdid,c.class_name,sec.section_name,s.classid,sec.sectionid");
		$this->db->where('a.date',$date);
		$this->db->where('a.status','P');
		$this->db->like('a.message',':');
		$this->db->where('s.branchid',$branchid);
		$this->db->join('students s','s.stdid=a.studentid');
		$this->db->join('classes c','c.classid=s.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		$query = $this->db->get('attendance a');
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			$students = "";
		}
	}
	function ProgressReportList($classid,$sectionid,$branchid)
	{
		$this->db->select("s.GR_number,s.name,s.stdid,r.remarks,c.class_name,sec.section_name,r.id")->from("students s");
		$this->db->where('s.classid',$classid);
		$this->db->where('s.sectionid',$sectionid);
		$this->db->join('classes c','c.classid=s.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		$this->db->join('student_report r','r.GR_number=s.GR_number');
		$this->db->where('s.branchid', $branchid);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function studentRankingList($classid,$sectionid,$branchid)
	{
		$this->db->select("s.GR_number,s.name,s.stdid,r.rank,c.class_name,sec.section_name,r.id")->from("students s");
		$this->db->where('s.classid',$classid);
		$this->db->where('s.sectionid',$sectionid);
		$this->db->join('classes c','c.classid=s.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		$this->db->join('student_ranking r','r.GR_number=s.GR_number');
		$this->db->where('s.branchid', $branchid);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	
	function getClasses()
	{
		$this->db->select('classid,class_name');
		$this->db->from('classes');
		 $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function getSections()
	{
		$this->db->select('sectionid,section_name');
		$this->db->from('sections');
		 $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function getStudentsList($branchid,$classid,$sectionid)
	{
		$this->db->select('s.name,s.GR_number');
		$this->db->from('students s');
		$this->db->where('s.classid',$classid);
		$this->db->where('s.sectionid',$sectionid);
		$this->db->where('s.branchid',$branchid);
		 $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function updateAccessToken($post,$token,$table)
	{
		$this->db->where($post['user'], $post['userid']);
		$data['reg_id']= $token;
        $update = $this->db->update($table, $data);
	}
	function updateDeviceToken($post,$token,$table)
	{
		$this->db->where($post['user'], $post['userid']);
		$data['device_token']= $token;
        $update = $this->db->update($table, $data);
	}
	public function getTeacherduties($branchid)
	{
		$this->db->select('d.name as duty_name,a.name as area_name,t.*,tt.teacher_name');
		$this->db->where('tt.branchid', $branchid);
		$this->db->join('teacher as tt', 'tt.teacherid=t.teacherid');
		$this->db->join('extra_duties as d', 'd.id=t.duty_id');
		$this->db->join('extra_duties_area as a', 'a.id=t.area_id');
        $query = $this->db->get('teacher_duties t');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getTeacherLeaves($teacherid)
	{
		$this->db->select("l.*,t.teacher_name");
        $this->db->where('l.sender', "teacher");
		$this->db->join('teacher t', "t.teacherid = l.userid");
		$this->db->where('t.teacherid', $teacherid);
		$this->db->order_by('id', 'desc');
        $query = $this->db->get('leaves l');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function parent_list($branchid)
	{
		$this->db->select('p.ptid as parentid,p.PR_number,p.father_name,p.reg_id, p.device_token');
		$this->db->join('students s','s.PR_number=p.PR_number');
		$this->db->where('s.branchid',$branchid);
		$query = $this->db->get('parents p');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function teachers_list($branchid)
	{
		$this->db->select('teacherid,teacher_name');
		$this->db->where('t.branchid',$branchid);
		$query = $this->db->get('teacher t');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function getStudentParentReg($stdid)
	{
		$this->db->select('p.reg_id,p.PR_number, p.device_token');
		$this->db->join('parents p','p.PR_number=s.PR_number');
		$this->db->where('s.stdid',$stdid);
		$query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
			return $query->row_array();
        } else {
            return "";
        }
	}
	public function getParentDetail($pr_number)
	{
		$this->db->select('p.reg_id,p.PR_number, p.device_token');
		$this->db->where('p.PR_number',$pr_number);
		$query = $this->db->get('parents p');
        if ($query->num_rows() > 0) {
            $res = $query->row_array();
			return $res;
        } else {
            return "";
        }
	}
	public function getTeacherDetail($teacherid)
	{
		$this->db->select('t.reg_id, t.device_token');
		$this->db->where('t.teacherid',$teacherid);
		$query = $this->db->get('teacher t');
        if ($query->num_rows() > 0) {
            $res = $query->row_array();
			return $res;
        } else {
            return "";
        }
	}
	public function checkStudentfeeforCurrentMonth($gr_number='')
	{
		$this->db->select('a.GR_number');
		$this->db->where('a.GR_number',$gr_number);
		$this->db->like('a.paydate',date('Y-m'));
        $query = $this->db->get('fee_history a');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getGalleryImages($category)
	{
		$this->db->select('*');
		$this->db->where('title',$category);
		$query = $this->db->get('multi_uploader_gallery');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getChilds($pr_number)
	{
		$this->db->select('s.GR_number');
		$this->db->where('p.PR_number',$pr_number);
		$this->db->from('parents p');
		$this->db->join('students s','p.PR_number=s.PR_number');
		$query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
	}
	public function getChildsbyid($ptid)
	{
		$this->db->select('s.GR_number');
		$this->db->where('p.ptid',$ptid);
		$this->db->from('parents p');
		$this->db->join('students s','p.PR_number=s.PR_number');
		$query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
	}
}

?>
