<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Common_model extends CI_Model {



    public $table;



    public function __construct() {

        parent::__construct();

    }



    public function insert($table, $data) {

        $this->db->set($data);

        $this->db->insert($table);

        return $this->db->insert_id();

    }



    public function update($table, $id, $data) {

        $this->db->where('id', $id);

        $this->db->set($data);

        $this->db->update($table);

        return $id;

        //return $this->db->insert_id();

    }

    public function getRowsusermonths($type,$branchid) {

        

		if($type == 'student')

		{

			$this->db->select('m.*,s.name,n.name as month_name,c.class_name');

			$this->db->join('students s', 's.GR_number=m.userid');

			$this->db->join('classes c', 'c.classid=s.classid');

			$this->db->where('s.branchid', $branchid);

		}

		else if($type == 'teacher')

		{

			$this->db->select('m.*,t.teacher_name,n.name as month_name,t.picture');

			$this->db->join('teacher t', 't.teacherid=m.userid');

			$this->db->where('t.branchid', $branchid);

		}

		$this->db->join('months n', 'n.id=m.month');

		$this->db->where('m.type', $type);

        $query = $this->db->get('userofmonth m');

        if ($query->num_rows() > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

    }

    public function truncate($table) {

        $this->db->truncate($table);

    }



    public function delete($table, $id) {

        $this->db->where('id', $id);

        $this->db->delete($table);

    }

	public function get_userofmonth($id)

	{

		$this->db->select("u.*")->from('userofmonth'." u");

		$this->db->where('u.id',$id);

		$query = $this->db->get();

        if ($query->num_rows() > 0) {

            return $query->row();

        } else {

            return FALSE;

        }

	}

    public function get_row($table, $id) {

        $this->db->select("u.*")->from($table." u");

		if($table == 'classes')

		{

			$this->db->where('u.classid', $id);

		}

		else if($table == 'sections')

		{

			$this->db->where('u.sectionid', $id);

		}

		else if($table == "teacher")

		{

			$this->db->where('u.teacherid', $id);

		}

		else if($table == "principal")

		{

			$this->db->where('u.id', $id);

		}

		else if($table == "accounts" || $table == "bank_accounts")

		{

			$this->db->where('u.id', $id);

		}

		else{

			$this->db->where('u.ptid', $id);

		}

        $query = $this->db->get();

        if ($query->num_rows() == 1) {

            return $query->row();

        } else {

            return FALSE;

        }

    }



    function get_page($id) {

        $this->db->where("page_id", $id);

        $page = $this->db->get("page");

        if ($page->num_rows() > 0) {

            return $page->row();

        } else {

            return false;

        }

    }



    function get_menu($id) {

        $this->db->where("menu_id", $id);

        $page = $this->db->get("menu");

        if ($page->num_rows() > 0) {

            return $page->row();

        } else {

            return false;

        }

    }



    function get_product($id) {

        $this->db->where("id", $id);

        $page = $this->db->get("product");

        if ($page->num_rows() > 0) {

            return $page->row();

        } else {

            return false;

        }

    }



    /* =================================================

     *              get countries list

      ===================================================== */



    public function get_all_rows($table) {



        $query = $this->db->get($table);

		if($table == 'extra_duties')

		{

			 $this->db->order_by("id", 'desc');

		}

        if ($query->num_rows() > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

    }

	public function get_all_rows_table($table) {

		$this->db->where('branchid', $this->session->userdata('principle_branchid'));

        $query = $this->db->get($table);

		

        if ($query->num_rows() > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

    }

	public function get_all_rows_by_branchid($table) 

	{

		if($table == 'teacher')

		{

			$this->db->select('teacher_name,teacherid');

			$this->db->where('t.branchid', $this->session->userdata('principle_branchid'));

			$query = $this->db->get('teacher t');

		}

		else if($table == 'students')

		{

			$this->db->select('s.name,s.GR_number');

			$this->db->where('s.branchid', $this->session->userdata('principle_branchid'));

			$query = $this->db->get('students s');

		}

		else if($table == 'parents')

		{

			$this->db->select('p.ptid,p.father_name');

			//$this->db->where('p.branchid', $this->session->userdata('principle_branchid'));

			$query = $this->db->get('parents p');

		}

        if ($query->num_rows() > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

    }

	public function get_all_rows_with_limit($table) {



		$this->db->order_by('id','desc');

		$this->db->limit(20);

        $query = $this->db->get($table);



        if ($query->num_rows() > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

    }



    public function get_all_stories($table) {

        $query = $this->db->get($table);

        if ($query->num_rows > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

    }



    public function get_all_stories_count($table) {

        $this->db->select('s.*,u.user_id,u.fullname,u.photo,u.city,u.country');

        $this->db->join('user as u', 's.Style_inspect_id=u.user_id');

        $query = $this->db->get('stories as s');

        if ($query->num_rows > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

    }



    public function get_all_product_following($user_id) {

        $this->db->where('f.follower_id', $user_id);

        $this->db->join('product p', 'p.id=f.product_id', 'left');

        $query = $this->db->get('product_followers f');

        if ($query->num_rows > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

    }



    public function get_all_product_following_count($user_id) {

        $this->db->where('f.follower_id', $user_id);

        $this->db->join('product p', 'p.id=f.product_id', 'left');

        $query = $this->db->get('product_followers f');

        return $query->num_rows;

    }



    public function search_row($table,$id) {

		if($table != 'fee_history' && $table != 'online_results')

		{

			$this->db->select("e.*,s.stdid as studentid,sb.subject_name as subject")->from("homework as e");

			$this->db->where('s.GR_number', $id);

			$this->db->where('e.status', 'Y');

			$this->db->join('students s', 's.classid=e.classid');

			$this->db->join('subjects sb', 'sb.subjectid=e.subjectid');

			//$this->db->where('date', date('Y-m-d'));

			$this->db->order_by('e.id', 'desc');

			$query = $this->db->get();

			if ($query->num_rows() > 0) {

				return $query->result();

			} else {

				return FALSE;

			}

		}

		else if($table == 'online_results'){

			$this->db->where('GR_number',$id);

			$this->db->limit(5);

			$query = $this->db->get($table);

			if ($query->num_rows() > 0) {

				return $query->result();

			} else {

				return FALSE;

			}

		}

		else if($table == 'fee_history')

		{

			$this->db->select('f.*,c.class_name,sec.section_name');

			$this->db->join('students s', 's.GR_number=f.GR_number');

			$this->db->join('classes c', 'c.classid=s.classid');

			$this->db->join('sections sec', 'sec.sectionid=s.sectionid');

			$this->db->where('f.GR_number',$id);

			$this->db->order_by('f.GR_number','desc');

			$query = $this->db->get($table." as f");

			if ($query->num_rows() > 0) {

				return $query->result();

			} else {

				return FALSE;

			}

		}

		else

		{

			$this->db->where('studentid',$id);

			$this->db->order_by('studentid','desc');

			//$this->db->limit(6);

			$query = $this->db->get($table);

			if ($query->num_rows() > 0) {

				return $query->result();

			} else {

				return FALSE;

			}

		}

		

       

    }



    public function search_delete($table, $search) {

        $this->db->where($search);

        $this->db->delete($table);

    }

	

	public function user_delete($table, $id, $type) {

        $this->db->where('month',$id);

		$this->db->where('type',$type);

        $this->db->delete($table);

    }

    public function run_query($query) {

        return $this->db->query($query);

    }



    function delteUserdata($table, $col, $user) {

        $this->db->where($col, $user);

        $this->db->delete($table);

    }



    function update_admin_password($password) {

        $data['password'] = md5($password);

        $this->db->where("id", $this->session->userdata('admin_id'));

        $this->db->update("user", $data);

    }



    function update_seller_password($password) {

        $data['password'] = md5($password);

        $this->db->where("user_id", $this->session->userdata('seller_id'));

        $this->db->update("user", $data);

    }



    function get_all_my_stories($check='') {

        $stories = '';

        if($check=='myinspiration'){

            $user_id = $this->session->userdata('user_id');

            $this->db->select('s.*,u.user_id,u.fullname,u.photo,u.city,u.country');

            $this->db->from('stories as s');

            $this->db->join('story_followers as sf', 's.id=sf.story_id');

            $this->db->join('user as u', 's.Style_inspect_id=u.user_id');

            $this->db->where('sf.follower_id', $user_id);

            $query = $this->db->get();

            if ($query->num_rows() > 0) {

                $res = $query->result();

                foreach ($res as $val) {

                    $stories[] = $val;

                }

            }

        }

        if($check!='following'){

            $this->db->select('s.*,u.user_id,u.fullname,u.photo,u.city,u.country');

            $this->db->from('stories as s');

            $this->db->where('Style_inspect_id', $this->session->userdata('user_id'));

            $this->db->join('user as u', 's.Style_inspect_id=u.user_id');

            $query = $this->db->get();

            if ($query->num_rows() > 0) {

                $res = $query->result();

                foreach ($res as $val) {

                    if ($val->id && $stories) {

                        if (!in_array($val->id, $stories)) {

                            $stories[] = $val;

                        }

                    } else {

                        $stories[] = $val;

                    }

                }

            }

        }

        if ($stories) {

            return $stories;

        } else {

            return false;

        }

    }



    public function get_all_rows_product($table, $sort) {

        $sort = $this->input->post("sort");

        $filter = $this->input->post("filter");

        $filter_type = $this->input->post('type_filter');

        $is_new = $this->input->post("is_new");

        if ($is_new) {

            $this->db->where('p.is_new', 1);

        } else {

            $this->db->where('p.is_new', 0);

        }

        if ($filter_type != 'product') {

            $this->db->select('p.*');

            //$this->db->join('product_followers as pf', 'p.id=pf.product_id');

            //$this->db->where('pf.follower_id', $this->session->userdata('user_id'));

        }

        //if ($sort == "price") {

        $this->db->from('product as p');

        if ($sort == '1') {

            $this->db->where('p.price >=', 0);

            $this->db->where('p.price <', 20);

        } else if ($sort == '2') {

            $this->db->where('p.price >', 20);

            $this->db->where('p.price <', 50);

        } else if ($sort == '3') {

            $this->db->where('p.price >', 50);

            $this->db->where('p.price <', 200);

        } else if ($sort == '4') {

            $this->db->where('p.price >', 200);

            $this->db->where('p.price <', 500);

        } else if ($sort == '5') {

            $this->db->where('p.price >', 500);

            $this->db->where('p.price <', 5000);

        } else if ($sort == '6') {

            $this->db->where('p.price >', 5000);

        }

        $this->db->where('p.date_expiry >', date('Y-m-d H:i:s'));

        if ($filter != 'Everything') {

            $this->db->where('p.category_id', $filter);

        }

        //$this->db->where('p.status', '1');

        $this->db->order_by('price', 'DESC');

        $query = $this->db->get();



        //echo $this->db->last_query();die;

        if ($query->num_rows() > 0) {

            return $query->result();

        } else {

            return false;

        }

//        } elseif ($sort == "rating") {

//            $this->db->where('p.date_expiry >', date('Y-m-d H:i:s'));

//            $this->db->where('p.status', '1');

//            if ($filter != 'Everything') {

//                $this->db->where('p.category_id', $filter);

//            }

//            $this->db->group_by('p.id');

//            $this->db->select('p.*,CEIL(AVG(r.`rating`)) avg_rating');

//            $this->db->join('product_ratings r', 'p.id=r.product_id', 'left');

//            $this->db->order_by('avg_rating', 'DESC');

//            $query = $this->db->get('product as p');

//            if ($query->num_rows() > 0) {

//                return $query->result();

//            } else {

//                return false;

//            }

//        }

    }



    public function get_pages($table) {

        $this->db->select('page_id,title,link');

        $query = $this->db->get($table);

        if ($query->num_rows > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

    }



    public function get_pageByid($id) {

        $this->db->select('*');

        $this->db->where('page_id', $id);

        $query = $this->db->get('page');

        if ($query->num_rows > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

    }

    function update_admin($id,$data){

        $this->db->where("id",$id);

        $this->db->update("user", $data);

    }

	function get_today_birthday($studentid)

	{

		$this->db->select('*');

		$this->db->where('stdid',$studentid);

        $this->db->like('dob', date('m-d'));

        $query = $this->db->get('students');

        if ($query->num_rows() > 0) {

            return $query->row();

        } else {

            return FALSE;

        }

	}

	function get_today_teacherbirthday($teacherid)

	{

		$this->db->select('teacherid');

		$this->db->where('teacherid',$teacherid);

        $this->db->like('dob', date('m-d'));

        $query = $this->db->get('teacher');

        if ($query->num_rows() > 0) {

            return $query->row();

        } else {

            return FALSE;

        }

	}

	function get_today_attendace($studentid)

	{

		$this->db->select('a.*,s.name');

		$this->db->where('a.studentid',$studentid);

        $this->db->like('a.date', date('Y-m-d'));

		$this->db->join('students as s', 's.stdid=a.studentid');

        $query = $this->db->get('attendance as a');

        if ($query->num_rows() > 0) {

            return $query->row();

        } else {

            return FALSE;

        }

	}

	function get_events($post)

	{

		$post['to_date'] = date('Y-m-d',strtotime($post['to_date'])) ;

		$post['from_date'] = date('Y-m-d',strtotime($post['from_date'])) ;

		$this->db->select("*")->from("events");

		$this->db->where('event_date >=', $post['to_date']);

		$this->db->where('event_date <=', $post['from_date']);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

	}

	function get_students($classid='',$sectionid='',$limit=0,$offset=0)

	{

		$this->db->select('GR_number,name,PR_number');

		if($classid && $sectionid)

		{

			$this->db->where('classid',$classid);

			$this->db->where('sectionid',$sectionid);

		}

		if($limit != 0)

		{

			$this->db->limit($limit);

			$this->db->offset($offset);

		}

		

		$this->db->where('branchid', $this->session->userdata('principle_branchid'));

		

        $query = $this->db->get('students');

        if ($query->num_rows() > 0) 

		{

            return $query->result();

        } else 

		{

            return FALSE;

        }

	}

	function getProgressReport($gr_number)

	{

		$this->db->select('remarks');

		$this->db->where('GR_number',$gr_number);

		$query = $this->db->get('student_report');

        if ($query->num_rows() > 0) 

		{

            $result = $query->row();

			return $result->remarks;

        } else 

		{

            return FALSE;

        }

	}

	public function parent_list($branchid)

	{

		$this->db->select('p.ptid as parentid,p.PR_number,p.father_name,p.reg_id');

		$this->db->join('students s','s.PR_number=p.PR_number');

		$this->db->where('s.branchid',$branchid);

		$query = $this->db->get('parents p');

        if ($query->num_rows() > 0) {

            return $query->result();

        } else {

            return "";

        }

	}

	public function teachers_list($branchid)

	{

		$this->db->select('teacherid,teacher_name');

		$this->db->where('t.branchid',$branchid);

		$query = $this->db->get('teacher t');

        if ($query->num_rows() > 0) {

            return $query->result();

        } else {

            return "";

        }

	}

	

	public function getTeacherReg($teacherid)

	{

		$this->db->select('reg_id');

		$this->db->where('teacherid',$teacherid);

		$query = $this->db->get('teacher');

        if ($query->num_rows() > 0) {

			return $query->row_array();

        } else {

            return "";

        }

	}

	public function sendNotification($message,$title,$reg_id)

	{

		

		$url = 'https://fcm.googleapis.com/fcm/send';

 

       

		$message['title'] = $title;

		

		$fields = array(

            'to' => $reg_id,

            'data' => $message,

        );

		//print_R($fields);die;

		//echo json_encode($fields);die;

        // Set POST variables

        $url = 'https://fcm.googleapis.com/fcm/send';

 

        $headers = array(

            'Authorization: key=' . FIREBASE_API_KEY,

            'Content-Type: application/json'

        );

        // Open connection

        $ch = curl_init();

 

        // Set the url, number of POST vars, POST data

        curl_setopt($ch, CURLOPT_URL, $url);

 

        curl_setopt($ch, CURLOPT_POST, true);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

 

        // Disabling SSL Certificate support temporarly

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

 

        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

 

        // Execute post

        $result = curl_exec($ch);

        if ($result === FALSE) {

            die('Curl failed: ' . curl_error($ch));

        }

 

        // Close connection

        curl_close($ch);

		return $result;

	} 

	public function getStudentParentReg($stdid)

	{

		$this->db->select('p.reg_id,p.PR_number');

		$this->db->join('parents p','p.PR_number=s.PR_number');

		$this->db->where('s.stdid',$stdid);

		$query = $this->db->get('students s');

        if ($query->num_rows() > 0) {

			return $query->row_array();

        } else {

            return "";

        }

	}

	public function getParentDetail($pr_number)

	{

		$this->db->select('p.reg_id,p.PR_number');

		$this->db->where('p.PR_number',$pr_number);

		$query = $this->db->get('parents p');

        if ($query->num_rows() > 0) {

            $res = $query->row_array();

			return $res;

        } else {

            return "";

        }

	}

	public function getParentDetailbyid($id)

	{

		$this->db->select('p.reg_id,p.PR_number,p.device_token');

		$this->db->where('p.ptid',$id);

		$query = $this->db->get('parents p');

        if ($query->num_rows() > 0) {

            $res = $query->row_array();

			return $res;

        } else {

            return "";

        }

	}

	public function getParentDetailbystudent($gr_number)

	{

		$this->db->select('p.reg_id,p.PR_number');

		$this->db->where('s.GR_number',$gr_number);

		$this->db->join('students s','s.PR_number=p.PR_number');

		$query = $this->db->get('parents p');

        if ($query->num_rows() > 0) {

            $res = $query->row_array();

			return $res;

        } else {

            return "";

        }

	}

	public function getTeacherDetail($teacherid)

	{

		$this->db->select('t.reg_id');

		$this->db->where('t.teacherid',$teacherid);

		$query = $this->db->get('teacher t');

        if ($query->num_rows() > 0) {

            $res = $query->row_array();

			return $res;

        } else {

            return "";

        }

	}

	public function sendiOS($msg, $title, $token,$to,$dev = '')

	{

		if($token)

		{

			if($dev)

			{

				$apnsHost = 'gateway.sandbox.push.apple.com';

				$apnsCert = getcwd()."/assets/push_notifications_developement.pem";

			}

			else

			{

				$apnsHost = 'gateway.push.apple.com';

				$apnsCert = getcwd()."/assets/push_notifications_distribution.pem";

			}

			$apnsPort = 2195;

			$streamContext = stream_context_create();

			stream_context_set_option($streamContext, 'ssl', 'local_cert', $apnsCert);

			$apns = stream_socket_client('ssl://' . $apnsHost . ':' . $apnsPort, $error, $errorString, 2, STREAM_CLIENT_CONNECT, $streamContext);

			if(isset($msg['branchid']))

			{

				$branchid = $msg['branchid'];

			}

			else

			{

				$branchid = 0;

			}

			if(isset($msg['studentid']))

			{

				$payload['aps'] = array('alert' => $title, 'badge' => 1, 'sound' => 'default','body'=>$msg['message'],'category'=>$msg['action'],'userid'=>$msg['userid'],'to'=>$to,'studentid'=>$msg['studentid'],'branchid'=>$branchid);

			}

			else 

			{

				$payload['aps'] = array('alert' => $title, 'badge' => 1, 'sound' => 'default','body'=>$msg['message'],'category'=>$msg['action'],'userid'=>$msg['userid'],'to'=>$to,'branchid'=>$branchid);

			}

			$output = json_encode($payload);

			$token = pack('H*', str_replace(' ', '', $token));

			$apnsMessage = chr(0) . chr(0) . chr(32) . $token . chr(0) . chr(strlen($output)) . $output;

			$rs = fwrite($apns, $apnsMessage);

			//socket_close($apns);

			fclose($apns);

		}

		

    }

	public function SendSmS($phone_no, $msg)

	{

		$user="warshitech"; //your username

		$password="28454224"; //your password

		//$mobilenumbers="966507619378,966540421598"; //enter Mobile numbers comma seperated

		$mobilenumbers = $phone_no; //enter Mobile numbers comma seperated

		$message = $msg; //enter Your Message

		$senderid="ALHUKAMAA"; //Your senderid

		$messagetype="LNG"; //Type Of Your Message

		$DReports="Y"; //Delivery Reports

		$url="http://www.smscountry.com/SMSCwebservice_Bulk.aspx";

		$message = $message;

		$ch = curl_init();

		if (!$ch){die("Couldn't initialize a cURL handle");}

		$ret = curl_setopt($ch, CURLOPT_URL,$url);

		curl_setopt ($ch, CURLOPT_POST, 1);

		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

		curl_setopt ($ch, CURLOPT_POSTFIELDS,

		"User=$user&passwd=$password&mobilenumber=$mobilenumbers&message=$message&sid=$senderid&mtype=$messagetype&DR=$DReports");

		$ret = curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		//If you are behind proxy then please uncomment below line and provide your proxy ip with port.

		// $ret = curl_setopt($ch, CURLOPT_PROXY, "PROXY IP ADDRESS:PORT");

		$curlresponse = curl_exec($ch); // execute

		if(curl_errno($ch))

		echo 'curl error : '. curl_error($ch);

		if (empty($ret)) 

		{

		// some kind of an error happened

			die(curl_error($ch));

			curl_close($ch); // close cURL handler

		} else {

			$info = curl_getinfo($ch);

			curl_close($ch); // close cURL handler

			//echo "

			echo $curlresponse; //echo "Message Sent Succesfully" ;

		}

	}

	function get_all_students()

	{

		$this->db->select('s.stdid, s.GR_number, s.name,s.iqama_no, s.iqama_expiry,p.PR_number');

		$this->db->where('s.branchid', $this->session->userdata('principle_branchid'));

		$this->db->join('parents p','p.PR_number=s.PR_number');

		$query = $this->db->get('students s');

        if ($query->num_rows() > 0) 

		{

            return $query->result();

        } else 

		{

            return FALSE;

        }

	}

	function getWeeklytimetable($teacherid)

	{

		$this->db->where('w.teacherid',$teacherid);

		$this->db->order_by('period_no','ASC');

		$query = $this->db->get('weekly_timetable w');

        if ($query->num_rows() > 0) {

            $res = $query->result_array();

			return $res;

        } else {

            return "";

        }

	}

	function getClasstimetable($classid,$sectionid)

	{

		$this->db->where('w.classid',$classid);

		$this->db->where('w.sectionid',$sectionid);

		$this->db->order_by('w.period_no','ASC');

		$query = $this->db->get('class_timetable w');

        if ($query->num_rows() > 0) {

            $res = $query->result_array();

			return $res;

        } else {

            return "";

        }

	}

	function deletetimetable($data)

	{

		$this->db->where('teacherid', $data['teacherid']);

		$this->db->where('dayid', $data['dayid']);

		$this->db->where('period_no', $data['period_no']);

        $this->db->delete('weekly_timetable');

	}

	function deleteclasstable($data)

	{

		$this->db->where('classid', $data['classid']);

		$this->db->where('sectionid', $data['sectionid']);

		$this->db->where('dayid', $data['dayid']);

		$this->db->where('period_no', $data['period_no']);

        $this->db->delete('class_timetable');

	}

	function update_students_classes ($data)

	{

		$post['classid'] = $data['classid'];

		$post['sectionid'] = $data['sectionid'];

		$this->db->where('GR_number', $data['GR_number']);

		$this->db->where('PR_number', $data['PR_number']);

        $this->db->set($post);

        $this->db->update('students');

        return '';

	}

}



