<?php



if (!defined('BASEPATH'))

    exit('No direct script access allowed');



class Todaytimetable extends MY_Controller {



    public $site = 'EMITSOL International School | Parents';

    public $layout = 'teacher/layout';

    public $data = array();



    public function __construct() {

        parent::__construct();



        // If user not logged in take user out from here

        if (!$this->session->userdata('teacher_logged_in')) {

            redirect('teacher/auth');

        }

            

        // Prepare Data

        $this->data['site_name'] = $this->site;

        $this->data['title'] = $this->site;

        // Load models

		$this->load->model('teacher/Todaystimetable_model', 'TodaystimetableModel');

    }



    public function index() {

        $this->data['title'] = 'Timetable | Home';

		$this->data['content'] = 'timetable';

		$day = date('D');

		if($day == 'Mon')

		{

			$dayid = 1;

		}

		else if($day == 'Tue')

		{

			$dayid = 2;

		}

		if($day == 'Wed')

		{

			$dayid = 3;

		}

		if($day == 'Thu')

		{

			$dayid = 4;

		}

		if($day == 'Fri')

		{

			$dayid = 5;

		}

		if($day == 'Sat')

		{

			$dayid = 6;

		}

		if($day == 'Sun')

		{

			$dayid = 7;

		}

		$teacherid = $this->session->userdata['teacher_id'];

		$today_timetable = $this->TodaystimetableModel->getTimetable($dayid,$teacherid);

		if($today_timetable)

		{

			foreach ($today_timetable as$key=> $time) 

			{

				$time->lesson_info = $this->TodaystimetableModel->getLessoninfo($teacherid,$time->subjectid);

				$time->class_info = $this->TodaystimetableModel->getClassinfo($teacherid,$time->period_no,$time->classid,$time->sectionid);

			}

		}

		$substitutetimetable = $this->TodaystimetableModel->today_subtimetable($teacherid);

		if($substitutetimetable)

		{

			foreach ($substitutetimetable as$key=> $time) 

			{

				$time->lesson_info = $this->TodaystimetableModel->getLessoninfo($teacherid,$time->subjectid);

				$time->class_info = $this->TodaystimetableModel->getClassinfo($teacherid,$time->period_no,$time->classid,$time->sectionid);

			}

		}

		$this->data['today_substitutetimetable'] = $substitutetimetable;

		$this->data['today_timetable'] = $today_timetable;

        $this->load->view($this->layout, $this->data);

    }



	public function add()

	{

		$post = $_POST;

		$insert_id = $this->ComplaintsModel->add($post); 

		$this->data['title'] = 'Complaints | Home';

		$this->data['content'] = 'complaints';

		$this->data['insert']= $insert_id;

        $this->load->view($this->layout, $this->data);

	}

}