<?php



if (!defined('BASEPATH'))

    exit('No direct script access allowed');



class Profile extends MY_Controller {



    public $site = 'EMITSOL International School | Parents';

    public $layout = 'teacher/layout';

    public $data = array();



    public function __construct() {

        parent::__construct();



        // If user not logged in take user out from here

        if (!$this->session->userdata('teacher_logged_in')) {

            redirect('teacher/auth');

        }

            

        // Prepare Data

        $this->data['site_name'] = $this->site;

        $this->data['title'] = $this->site;

        $this->data['content'] = '';

        $this->data['page_heading'] = '';

        $this->data['profile'] = 'profile';

        // Load models

        $this->load->model('common_model', 'CommonModel');

		$this->load->model('teacher/teacher_model', 'TeacherModel');

        // Get Logged User

        $this->data['teacher_data'] = $this->CommonModel->get_row('teacher', $this->session->userdata('teacher_id')); 

    }



    public function index() {

        $this->data['title'] = 'Profile | Home';

		$this->data['content'] = 'profile';

        $this->load->view($this->layout, $this->data);

    }



    public function dashboard()

	{

        $this->data['title'] = 'Dashboard | Home';

		$this->data['content'] = 'dashboard';

		$this->data['birthday']  = $this->CommonModel->get_today_teacherbirthday($this->session->userdata('teacher_id'));

		$this->data['complaints']  = $this->TeacherModel->get_complaints($this->session->userdata('teacher_id'));

		$this->data['mteacher']  = $this->CommonModel->getRowsusermonths('teacher',$this->data['teacher_data']->branchid);

		$this->data['events'] = $this->CommonModel->get_all_rows('events');

        $this->load->view($this->layout, $this->data);

    }



    public function settings() {

        $this->data['page_heading'] = 'Profile';

        $this->data['heading'] = 'Application Owner Profile';

        $this->data['content'] = 'admin/profile/settings';

        $this->data['user']=$this->data['logged_admin'];

        $this->data['countries'] = $this->CommonModel->get_all_rows('country');

        $this->load->view($this->layout, $this->data);

    }

    public function changepassword(){

        $this->data['page_heading'] = 'Profile';

        $this->data['heading'] = 'Change Password';

        $this->data['content'] = 'admin/profile/change_pass';

        $this->load->view($this->layout, $this->data);

    }



    public function change_password() {

        $this->form_validation->set_rules('old_password', 'Old Password', 'trim|required|xss_clean');

        $this->form_validation->set_rules('new_password', 'New Password', 'trim|required|xss_clean');

        $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'trim|required|matches[new_password]|xss_clean');



        if ($this->form_validation->run() == FALSE) {

            if (validation_errors()) {

                $this->session->set_flashdata('msg', '<h4 class="error_msg">' . validation_errors() . '</h4>');

            }

            redirect('admin/profile/settings');

        } else {

            $old_password = md5($this->input->post('old_password'));

            $admin_data = $this->CommonModel->get_row('admin', $this->session->userdata('admin_id'));

           if($this->input->post('new_password') == $this->input->post('old_password')){

               $this->session->set_userdata('msg','<h4 class="error_msg">Old and New password are same, Please choose different new Password!.</h4>');

                ///$this->session->set_flashdata('msg', '<h4 class="error_msg">Old and New password are same, Please choose different new Password!.</h4>');

                redirect('admin/profile/changepassword');

            }else if($old_password != $admin_data->password) {

                $this->session->set_userdata('msg','<h4 class="error_msg">Wrong old password </h4>');

                redirect('admin/profile/changepassword');

            }else{

                $this->CommonModel->update_admin_password($this->input->post('new_password'));

                $this->session->set_userdata('msg','<h4 class="error_msg">Your password has been changed successfully.</h4>');

                redirect('admin/profile/changepassword');

            }

        }

    }

    function change_info(){

        $data=array(

            'first_name'=>$this->input->post('first_name'),

            'last_name'=>$this->input->post('last_name'),

            'email' =>$this->input->post('email')

            );

        $this->CommonModel->update_admin($this->session->userdata('admin_id'),$data);

        $this->session->set_userdata('msg', 'Your info has been changed successfully.');

        redirect('admin/profile');

    }

	function get_events()

	{

		$post = $_POST;

		$events = $this->CommonModel->get_events($post);

		$html = "";

		if($events)

		{

			foreach ($events as $e) 

			{

				$html .= '<tr><td valign="top">'.$e->event_date.'</td> <td valign="top">'.$e->event_name.'</td><td valign="top">'.$e->description.'</td></tr>';

			}

		}

		else{

			$html = "No Event found";

		}

		

		echo $html;

	}

}