<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Onlinepaper extends MY_Controller {

    public $site = 'EMITSOL International School | Parents';
    public $layout = 'teacher/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('teacher_logged_in')) {
            redirect('teacher/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('Onlinepaper_model');
        // Get Logged Teacher
        $this->data['teacher_data'] = $this->CommonModel->get_row('teacher', $this->session->userdata('teacher_id'));
    }

    public function index() {
        $this->data['title'] = 'Attendance | Home';
		$this->data['content'] = 'attendance';
		$teacherid = $this->session->userdata['teacher_id'];
        $this->load->view($this->layout, $this->data);
    }
	public function create_paper()
	{
		$this->data['title'] = 'Create Paper';
		$this->data['content'] = 'create_paper';
		$teacherid = $this->session->userdata['teacher_id'];
		
        $this->load->view($this->layout, $this->data);
	}
	public function save_paper(){
		
		$form_data = json_decode(file_get_contents('php://input'));

        foreach ($form_data as $key => $value) {
            $field[$value->name] = $value->value;
        }
        $formID = $field['formID'];
        $formFields = json_encode($field['formFields']);
		
		$this->session->set_userdata('online_paper', $formFields);
	
		
	}
	
	public function load_paper()
	{
		if(isset($this->session->userdata['online_paper']))
		{
			echo $this->session->userdata['online_paper'];	
		}
	}
	public function view_form()
	{
		
		
		$this->data['title'] = 'View Paper';
		$this->data['content'] = 'view_paper';
		$teacherid = $this->session->userdata['teacher_id'];
		
        $this->load->view($this->layout, $this->data);
		
	}
	
}