<?php

if (!defined('BASEPATH'))

    exit('No direct script access allowed');



class Auth extends MY_Controller {



    public $site = 'EMITSOL International School | Teacher';

    public $layout = 'admin/common/layout';

    public $data = array();



    public function __construct() {

        parent::__construct();        

        // Prepare Data

        $this->data['site_name'] = $this->site;

        $this->data['title'] = $this->site;

        $this->data['content'] = '';

        $this->data['msg'] = '';

        $this->load->model('teacher/auth_model', 'AuthModel');

    }

    public function index() {

        $this->data['title'] = $this->site;

        $this->load->view('teacher/login', $this->data);

    }



    public function login() {

            $username = $this->input->post('username');

            $password = $this->input->post('password');

            $user = $this->AuthModel->login($username, $password);

            if ($user) {

                 $this->register_session($user);

            } else {

                $this->data['msg'] = '<p class="error">ERROR: Login failed.</p>';

                $this->load->view('teacher/login',  $this->data);

            }

    }





    public function register_session($teacher) {

        $this->session->set_userdata('teacher_id', $teacher->teacherid);

        $this->session->set_userdata('teacher_logged_in', TRUE);  

		if($teacher->progress_report_enable =="Yes")

		{

			$this->session->set_userdata('is_progress', TRUE);  

		}

		else {

			$this->session->set_userdata('is_progress', FALSE);  

		}

		if($teacher->student_ranking_enable =="Yes")

		{

			$this->session->set_userdata('is_ranking', TRUE);  

		}

		else {

			$this->session->set_userdata('is_ranking', FALSE);  

		}

		$this->session->set_userdata('teacher_branchid', $teacher->branchid);  

        redirect('teacher/profile/dashboard');

    }

   

    public function logout() {

        $this->session->unset_userdata('teacher_logged_in');

        $this->session->unset_userdata('teacher_id');

		$this->session->unset_userdata('teacher_branchid');



        $this->session->sess_destroy();



        redirect('teacher/auth');

    }

    



    function createRandomPassword() {

        $chars = "abcdefghiHKJHIUHIUHKJNKNKJjkmnopqrstuvwxyz023456789";

        srand((double) microtime() * 1000000);

        $i = 0;

        $pass = '';

        while ($i <= 7) {

            $num = rand() % 33;

            $tmp = substr($chars, $num, 1);

            $pass = $pass . $tmp;

            $i++;

        }



        return $pass;

    }

}