<?php



if (!defined('BASEPATH'))

    exit('No direct script access allowed');



class Attendance extends MY_Controller {



    public $site = 'EMITSOL International School | Parents';

    public $layout = 'teacher/layout';

    public $data = array();



    public function __construct() {

        parent::__construct();



        // If user not logged in take user out from here

        if (!$this->session->userdata('teacher_logged_in')) {

            redirect('teacher/auth');

        }

            

        // Prepare Data

        $this->data['site_name'] = $this->site;

        $this->data['title'] = $this->site;

        // Load models

        $this->load->model('common_model', 'CommonModel');

		$this->load->model('teacher/attendance_model', 'AttendanceModel');

        // Get Logged Teacher

        $this->data['teacher_data'] = $this->CommonModel->get_row('teacher', $this->session->userdata('teacher_id'));

    }



    public function index() {

        $this->data['title'] = 'Attendance | Home';

		$this->data['content'] = 'attendance';

		$teacherid = $this->session->userdata['teacher_id'];

		$this->data['total_absent_months'] = $this->AttendanceModel->getMonthAbsents($teacherid);

		$this->data['today_attendance'] = $this->AttendanceModel->getAttendance($teacherid);

		$this->data['attendance_history'] = $this->AttendanceModel->getAttendanceHistory($teacherid);

        $this->load->view($this->layout, $this->data);

    }

	public function reply_teacher()

	{

		$post = $_POST;

		$this->AttendanceModel->reply_teacher($post);

	}

	function get_attendance_count()

	{

		$post = $_POST;

		$result = $this->AttendanceModel->get_attendance_count($post);

		if($result)

		{

			echo $result->total_attendance;

		}

	}

}