<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Addattendance extends MY_Controller {

    public $site = 'Al Hukama International School | Teacher';
    public $layout = 'principle/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principle_logged_in')) {
            redirect('principle/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('principle/Addattendance_model', 'AddattendanceModel');
		// Get Logged User
        $this->data['principle_data'] = $this->CommonModel->get_row('principle', $this->session->userdata('principle_id')); 
    }

    public function index() {
        $this->data['title'] = 'Add Attendance | Home';
		$this->data['teachers'] = $this->AddattendanceModel->getTeacher();
		$this->data['content'] = 'attendance';
		$date = date('Y-m-d');
		$this->data['absent_teacher'] = $this->AddattendanceModel->countAttendance($date,'A');
		$this->data['present_teacher'] = $this->AddattendanceModel->countAttendance($date,'P');
        $this->load->view($this->layout, $this->data);
    }

	
	public function add_attendance()
	{
		$selected_val = $_POST['selected_val'];
		$note_arr = $_POST['note_arr'];
		foreach ($selected_val as $key=> $std) 
		{
			$teacher_data = explode("-",$std);
			$post['teacherid'] =  $teacher_data[0];
			$post['status'] =  $teacher_data[1];
			$post['message'] = $note_arr[$key];
			if($post['status'] == 'A' && $note_arr[$key] == '')
			{
				$post['message'] = 'Why you are absent today ?';
			}
			$post['date'] = date('Y-m-d');
			$this->AddattendanceModel->Addattendance($post);
		}
	}
	function do_upload($image_path,$image_name)
    {
            $config['upload_path'] = $image_path;
            $config['allowed_types'] = 'gif|jpg|png|docx';
             $config['max_size']	= '10000000000';
            $config['max_width']  = '300000000';
            $config['max_height']  = '300000000';

            $this->load->library('upload', $config);

            if ( ! $this->upload->do_upload('image',$image_name))
            {
                $this->session->set_userdata('msg', $this->upload->display_errors());
                echo $this->upload->display_errors();die;
            }
			else{
				$data = $this->upload->data();
				$image_name =  $data['raw_name'].$data['file_ext'];
			}
			
            return $image_name;
    }
	function do_uploadfile($file)
    {
		$allowedExts = array("pdf", "doc", "docx");
		$extension = explode(".", $file["document"]["name"]);
		$file_name = "";
		if(isset($extension[1]))
		{
			$extension = $extension[1];
			if (in_array($extension, $allowedExts))
			{
				if ($file["document"]["error"] > 0)
				{
				   echo "Return Code: " . $file["document"]["error"] . "<br>";
				}
				else
				{
				   $file_name =  time(). $file["document"]["name"];
				   $file = move_uploaded_file($file["document"]["tmp_name"],"assets/homework/" .$file_name);
				}
			}
		}
		return $file_name;
	}
	function add_note()
	{
		$post['class_note'] = $_POST['class_note'];
		$post['what_done'] = $_POST['what_done'];
		$post['classid'] = $this->session->userdata('classid');
		$post['sectionid'] = $this->session->userdata('sectionid');
		$post['period_no'] = $this->session->userdata('period');
		$post['teacherid'] =  $this->session->userdata('teacher_id');
		//update
		$this->db->where('date', date('Y-m-d'));
        $this->db->delete('class_feedback');
		
		$post['date'] = date('Y-m-d');
		$this->db->set($post);
        $insert = $this->db->insert("class_feedback");
        return $this->db->insert_id();
	}
	public function attendancelisting()
	{
		$this->data['attendance'] = $this->AddattendanceModel->getAttendance();
		$this->data['content']  = 'tattendence_listing';
		$this->load->view($this->layout, $this->data);
	}
	public function edit($date)
	{
		$this->data['title'] = 'Edit Attendance | Home';
		$this->data['teachers'] = $this->AddattendanceModel->getAttendance($date);
		$this->data['absent_teacher'] = $this->AddattendanceModel->countAttendance($date,'A');
		$this->data['present_teacher'] = $this->AddattendanceModel->countAttendance($date,'P');
		$this->data['date'] = $date;
		$this->data['content'] = 'attendance_edit';
        $this->load->view($this->layout, $this->data);
	}
	public function print_tattendance($date)
	{
		$this->data['title'] = 'Print Attendance';
		$this->data['teachers'] = $this->AddattendanceModel->getAttendance($date);
		//$this->data['absent_teacher'] = $this->AddattendanceModel->countAttendance($date,'A');
		//$this->data['present_teacher'] = $this->AddattendanceModel->countAttendance($date,'P');
		$this->data['date'] = $date;
//		$this->load->library('mpdf/mpdf');
                $this->load->library('m_pdf');
		
		$html = $this->load->view('principle/tattendance_print', $this->data, true);
		$mpdf = new mPDF('ar-s', 'A4', '', 'Arial', 16, 16, 12, 12, 9, 9);
		// $html = iconv("windows-1256","UTF-8//IGNORE",$html);
		$mpdf->SetDisplayMode('fullpage');
		$mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
		// LOAD a stylesheet
		$stylesheet = file_get_contents('./assets/css/pdf.css');
		$mpdf->WriteHTML($stylesheet, 1);    // The parameter 1 tells that this is css/style only and no body/html/text
		//$mpdf->SetHTMLFooter($footer);
		$mpdf->SetFooter($this->data['settings']->site_name . '|{PAGENO}|' . date(DATE_RFC822));
		$mpdf->WriteHTML($html, 2);

		$file_name = date('Y_m_d_His') . '_fee_list.pdf';
		$mpdf->Output($file_name, 'I'); // F = Move to Directory, I = View, D = Download    
        
	}
	function edit_attendance()
	{
		$selected_val = $_POST['selected_val'];
		$note_arr = $_POST['note_arr'];
		foreach ($selected_val as $key=> $std) 
		{
			$teacher_data = explode("-",$std);
			$post['teacherid'] =  $teacher_data[0];
			$post['status'] =  $teacher_data[1];
			$post['message'] = $note_arr[$key];
			$post['date'] = date('Y-m-d');
			$this->AddattendanceModel->Updateattendance($post);
		}
	}
	public function teacher($id)
	{
		$this->data['title'] = 'Attendance Detail | Home';
		
		$date = "";
		if(isset($_GET['month']) && isset($_GET['year']))
		{
			$date = $_GET['year']."-".$_GET['month'];
		}
		$teacher_monthly = $this->AddattendanceModel->getteacherAttendance($id,$date);
		$teacher_name = "";
		if($teacher_monthly)
		{
			foreach ($teacher_monthly as $t) 
			{
				$teacher_name = $t->teacher_name;
				break;
			}
		}
		
		
		$this->data['teacher_monthly'] =$teacher_monthly;
		$this->data['teacher_name'] = $teacher_name;
		$this->data['content'] = 'attendance_detail';
        $this->load->view($this->layout, $this->data);
	}
}