<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Reports extends MY_Controller {

    public function __construct() {
        parent::__construct();

        $this->isLogged();
        if(!havePermissions($this->data['member']->mem_permissions, '16')){
            redirect('index', 'refresh');
        }
        
        $this->load->library('pagination');
    }
    
    public function index() {
        $this->data['pageView'] = 'reports';
        $this->data['report'] = $this->uri->segment(2);
        $this->data['get'] = $this->input->get();
        $this->load->model('appointment_model');

        $this->data['rows'] = $this->appointment_model->getReport($this->data['get']);
        $config['base_url'] = base_url('reports/index');
        $config['total_rows'] = count($this->data['rows']);
        $config['per_page'] = 1000;
        $config['uri_segment'] = 3;
        if (count($_GET) > 0) $config['suffix'] = '?' . http_build_query($_GET, '', "&");
        $config['first_url'] = $config['base_url'] . $config['suffix'];
        $this->pagination->initialize($config);
        $start = $this->uri->segment(3);
        $this->data['rows'] = $this->appointment_model->getReport($this->data['get'], $start, $config['per_page']);
        $this->data['pagination'] = $this->pagination->create_links();

        $this->load->view('includes/siteMaster', $this->data);
    }
    
    public function bookings() {
        $this->data['pageView'] = 'reports';
        $this->data['report'] = $this->uri->segment(2);
        $this->data['get'] = $this->input->get();
        $this->load->model('booking_model');

        $this->data['rows'] = $this->booking_model->getReport($this->data['get']);
        $config['base_url'] = base_url('reports/bookings');
        $config['total_rows'] = count($this->data['rows']);
        $config['per_page'] = 1000;
        $config['uri_segment'] = 3;
        if (count($_GET) > 0) $config['suffix'] = '?' . http_build_query($_GET, '', "&");
        $config['first_url'] = $config['base_url'] . $config['suffix'];
        $this->pagination->initialize($config);
        $start = $this->uri->segment(3);
        $this->data['rows'] = $this->booking_model->getReport($this->data['get'], $start, $config['per_page']);
        $this->data['pagination'] = $this->pagination->create_links();

        $this->load->view('includes/siteMaster', $this->data);
    }
    
    public function orders() {
        $this->data['pageView'] = 'reports';
        $this->data['report'] = $this->uri->segment(2);
        $this->data['get'] = $this->input->get();
        $this->load->model('order_model');

        $this->data['rows'] = $this->order_model->getReport($this->data['get']);
        $this->load->view('includes/siteMaster', $this->data);
    }
    
    public function payments() {
        $this->data['pageView'] = 'reports';
        $this->data['report'] = $this->uri->segment(2);
        $this->data['get'] = $this->input->get();
        $this->load->model('order_model');

        $this->data['rows'] = $this->order_model->getPaymentReport($this->data['get']);

        $this->load->view('includes/siteMaster', $this->data);
    }
    
    public function customers() {
        $this->data['pageView'] = 'reports';
        $this->data['report'] = $this->uri->segment(2);
        $this->data['get'] = $this->input->get();
        $this->load->model('customer_model');

        $this->data['rows'] = $this->customer_model->getReport($this->data['get']);
        $config['base_url'] = base_url('reports/customers');
        $config['total_rows'] = count($this->data['rows']);
        $config['per_page'] = 1000;
        $config['uri_segment'] = 3;
        if (count($_GET) > 0) $config['suffix'] = '?' . http_build_query($_GET, '', "&");
        $config['first_url'] = $config['base_url'] . $config['suffix'];
        $this->pagination->initialize($config);
        $start = $this->uri->segment(3);
        $this->data['rows'] = $this->customer_model->getReport($this->data['get'], $start, $config['per_page']);
        $this->data['pagination'] = $this->pagination->create_links();

        $this->load->view('includes/siteMaster', $this->data);
    }
    
    public function users() {
        $this->data['pageView'] = 'reports';
        $this->data['report'] = $this->uri->segment(2);
        $this->data['get'] = $this->input->get();
        $this->load->model('member_model');

        $this->data['rows'] = $this->member_model->getReport($this->data['get']);
        $config['base_url'] = base_url('reports/customers');
        $config['total_rows'] = count($this->data['rows']);
        $config['per_page'] = 1000;
        $config['uri_segment'] = 3;
        if (count($_GET) > 0) $config['suffix'] = '?' . http_build_query($_GET, '', "&");
        $config['first_url'] = $config['base_url'] . $config['suffix'];
        $this->pagination->initialize($config);
        $start = $this->uri->segment(3);
        $this->data['rows'] = $this->member_model->getReport($this->data['get'], $start, $config['per_page']);
        $this->data['pagination'] = $this->pagination->create_links();

        $this->load->view('includes/siteMaster', $this->data);
    }
    
    function change_step() {
        $this->session->set_userdata('step', $this->uri->segment(3));
        redirect('reports', 'refresh');
    }
	
	public function cash_book() {
        $this->data['pageView'] = 'reports';
        $this->data['report'] = $this->uri->segment(2);
        $this->load->model('booking_model');
		$start_date = $this->input->get('from_date');
		$end_date = $this->input->get('to_date');
		
		$date = date('Y-m-d');
        $booking = $this->booking_model->cash_book($date, $start_date, $end_date);
		$this->data['indoor_total_cash'] = 0;
		$this->data['outdoor_total_cash'] = 0;
		$this->data['sale_total_cash'] = 0;
		if($booking)
		{
			foreach ($booking as $b) 
			{
				$service = unserialize($b->book_services);
				if(isset($service[0]['srv_id']))
				{
					$serviceid = $service[0]['srv_id'];
				}
				$serviceid = getServiceid($serviceid);
				if($b->book_type == 'sale')
				{
					$this->data['sale_total_cash'] = $this->data['sale_total_cash'] + ($b->book_total - $b->book_balance);
				}
				else if($serviceid == 2)
				{
					$this->data['outdoor_total_cash'] = $this->data['outdoor_total_cash'] + ($b->book_total - $b->book_balance);
				}
				else if($serviceid == 1)
				{
					$this->data['indoor_total_cash'] = $this->data['indoor_total_cash'] + ($b->book_total - $b->book_balance);
				}
			}
		}
        $this->load->view('includes/siteMaster', $this->data);
    }
	public function services() 
	{
        $this->data['pageView'] = 'reports';
        $this->data['report'] = $this->uri->segment(2);
        $this->data['get'] = $this->input->get();
        $this->load->model('booking_model');
		$service_id = "";
		if(isset($_GET['srv_id']))
		{
			$service_id = $_GET['srv_id'];
			unset($this->data['get']['srv_id']);
		}
		
		$bookings = $this->booking_model->getReport($this->data['get']);
		$booking_arr = array();
		if(isset($_GET['srv_id']))
		{
			foreach ($bookings as$key=> $book)
			{
				$srv_id = unserialize($book->book_services);
				$srv_id = $srv_id[0]['srv_id'];
				if($service_id == $srv_id)
				{
					$booking_arr[] = $book;
				}
			}
		}
        $this->data['rows'] = $booking_arr;
        $config['base_url'] = base_url('reports/bookings');
        $config['total_rows'] = count($this->data['rows']);
        $config['per_page'] = 1000;
        $config['uri_segment'] = 3;
		
		
        if (count($_GET) > 0) $config['suffix'] = '?' . http_build_query($_GET, '', "&");
        $config['first_url'] = $config['base_url'] . $config['suffix'];
        $this->pagination->initialize($config);
        $start = $this->uri->segment(3);
        $this->data['pagination'] = $this->pagination->create_links();

        $this->load->view('includes/siteMaster', $this->data);
    }
}
?>