<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Weeklylessonplan extends MY_Controller {

    public $site = 'EMITSOL International School | Teacher';
    public $layout = 'teacher/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('teacher_logged_in')) {
            redirect('teacher/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
		$this->load->model('teacher/weeklylessonplan_model', 'WeeklyLessonPlanModel');
    }

    public function index() {
        $this->data['title'] = 'Weekly Lesson Plan | Home';
		$this->data['content'] = 'weeklylessonplan';
		$this->data['classes'] = $this->WeeklyLessonPlanModel->getClasses();
		$this->data['subjects'] = $this->WeeklyLessonPlanModel->getSubjects();
		$this->data['sections'] = $this->WeeklyLessonPlanModel->getSections($this->session->userdata('teacher_branchid'));
		$this->data['weeklylessonplans'] = $this->WeeklyLessonPlanModel->getWeekyLessonPlan($this->session->userdata('teacher_id'));
        $this->load->view($this->layout, $this->data);
    }
	public function add()
	{
		$post = $_POST;
		//$post['sender'] = 'teacher';
		//$post['receiver'] = 'principle';
		$insert_id = $this->WeeklyLessonPlanModel->add($post); 
		$this->data['title'] = 'Weekly Lesson Plan | Home';
		$this->data['content'] = 'weeklylessonplan';
		$this->data['insert']= $insert_id;
		$this->data['classes'] = $this->WeeklyLessonPlanModel->getClasses();
		$this->data['subjects'] = $this->WeeklyLessonPlanModel->getSubjects();
		$this->data['sections'] = $this->WeeklyLessonPlanModel->getSections($this->session->userdata('teacher_branchid'));
		$this->data['weeklylessonplans'] = $this->WeeklyLessonPlanModel->getWeekyLessonPlan($this->session->userdata('teacher_id'));
        $this->load->view($this->layout, $this->data);
	}
}