<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Teacherduty extends MY_Controller {

    public $site = 'EMITSOL International School | Principal';
    public $layout = 'principal/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principal_logged_in')) {
            redirect('principal/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('principal/Tduty_model', 'TdutyModel');
		$this->data['principal_data'] = $this->CommonModel->get_row('principal', $this->session->userdata('principal_id')); 
//		$this->load->model('parents/appointment_model', 'AppointmentModel');
//		$this->data['confirmation_date']  = $this->AppointmentModel->get_confirmation_date($this->session->userdata['parent_id']); 
    }

    public function index() {
        $this->data['title'] = 'Teacher Extra Duty | Home';
		$this->data['content'] = 'teacherduties';
		if($_POST)
		{
			$post = $_POST;
			//$post['to_date'] =	date('Y-m-d',  strtotime($post['to_date']));;
			//$post['from_date'] =	date('Y-m-d',  strtotime($post['from_date']));;
			$this->CommonModel->insert('teacher_duties',$post); 
			$this->data['insert'] = 'yes';
		}
		$this->data['teachers']  = $this->CommonModel->get_all_rows_by_branchid('teacher'); 
		$this->data['duties'] = $this->TdutyModel->getduty(); 
		$this->data['xduties']  = $this->CommonModel->get_all_rows('extra_duties'); 
		$this->data['duties_area']  = $this->CommonModel->get_all_rows('extra_duties_area');
        $this->load->view($this->layout, $this->data);
    }
	public function update($id='')
	{
		$this->data['title'] = 'Teacher Extra Duty | Home';
		$this->data['content'] = 'teacherduties_edit';
		if($_POST)
		{
			$post = $_POST;
			//$post['to_date'] =	date('Y-m-d',  strtotime($post['to_date']));
			//$post['from_date'] =	date('Y-m-d',  strtotime($post['from_date']));
			$this->CommonModel->update('teacher_duties',$id,$post); 
			$this->data['insert'] = 'yes';
		}
		$this->data['duty'] = $this->TdutyModel->getteacherduty($id); 
		$this->data['teachers']  = $this->CommonModel->get_all_rows_by_branchid('teacher'); 
		$this->data['xduties']  = $this->CommonModel->get_all_rows('extra_duties'); 
		$this->data['duties_area']  = $this->CommonModel->get_all_rows('extra_duties_area');
		$this->load->view($this->layout, $this->data);
	}
	public function delete($id)
	{
		$this->data['title'] = 'Teacher Extra Duty | Home';
		$this->data['content'] = 'teacherduties';
		$this->data['delete'] = $this->TdutyModel->delete($id); ;
		$this->data['teachers']  = $this->CommonModel->get_all_rows_by_branchid('teacher'); 
		$this->data['duties'] = $this->TdutyModel->getduty(); 
		$this->data['xduties']  = $this->CommonModel->get_all_rows('extra_duties'); 
		$this->data['duties_area']  = $this->CommonModel->get_all_rows('extra_duties_area');
        $this->load->view($this->layout, $this->data);
	}
}