<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Report extends MY_Controller {

    public $site = 'EMITSOL International School | Parents';
    public $layout = 'principal/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principal_logged_in')) {
            redirect('principal/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('principal/grading_model', 'grade');
		$this->load->model('common_model', 'CommonModel');
        // Get Logged Teacher
        $this->data['principal_data'] = $this->CommonModel->get_row('principal', $this->session->userdata('principal_id')); 
    }
	
	public function show_report($student_id , $class_id , $section_id , $term , $month)
	{
	  $this->data['title'] = 'Papers';
      $this->data['content'] = 'show_report';
	  $marks = $this->grade->get_marks_month($student_id , $term , $month);
	  $marks_data = array();
	  foreach($marks as $marks)
	  {
	    $marks_data[$marks["fksubject_id"]] = $marks; 	  
	  }
	  $this->data["marks"] = $marks_data;
	  $this->data['class'] = $this->grade->get_single_class_info($class_id);
	  $this->data['section'] = $this->grade->get_single_section_info($section_id);
	  $this->data['term'] = $term;
	  $this->data['month'] = $month;
	  $this->data['subject'] = $this->grade->get_assign_subject($this->data['principal_data']->branchid , $class_id);
	  $this->data['student'] = $this->grade->get_student_info($student_id); 
	  	
	  $this->load->view($this->layout, $this->data);	
	}
	
	
	public function show_report_term($student_id , $class_id , $section_id , $term)
	{
	  $this->data['title'] = 'Papers';
      $this->data['content'] = 'show_report_term';
	  $marks_1 = $this->grade->get_marks_first_month($student_id , $term );
	  $marks_2 = $this->grade->get_marks_second_month($student_id , $term );
	  $marks_3 = $this->grade->get_marks_third_month($student_id , $term );
	  $marks_4 = $this->grade->get_marks_last_month($student_id , $term );
	  
	  $marks_1_data = array();
	  $marks_2_data = array();
	  $marks_3_data = array();
	  $marks_4_data = array();
	  foreach($marks_1 as $marks_1)
	  {
	    $marks_1_data[$marks_1["fksubject_id"]] = $marks_1; 	  
	  }
	  
	  foreach($marks_2 as $marks_2)
	  {
	    $marks_2_data[$marks_2["fksubject_id"]] = $marks_2; 	  
	  }
	  
	  foreach($marks_3 as $marks_3)
	  {
	    $marks_3_data[$marks_3["fksubject_id"]] = $marks_3; 	  
	  }
	  
	  foreach($marks_4 as $marks_4)
	  {
	    $marks_4_data[$marks_4["fksubject_id"]] = $marks_4; 	  
	  }
	  
	  $this->data["marks_1"] = $marks_1_data;
	  $this->data["marks_2"] = $marks_2_data;
	  $this->data["marks_3"] = $marks_3_data;
	  $this->data["marks_4"] = $marks_4_data;
	  $this->data['class'] = $this->grade->get_single_class_info($class_id);
	  $this->data['section'] = $this->grade->get_single_section_info($section_id);
	  $this->data['term'] = $term;
	  $this->data['subject'] = $this->grade->get_assign_subject($this->data['principal_data']->branchid , $class_id);
	  $this->data['student'] = $this->grade->get_student_info($student_id); 
	  	
	  $this->load->view($this->layout, $this->data);	
	}
	
	
	public function report_month()
	{
	  $this->data['title'] = 'Papers';
      $this->data['content'] = 'report_month';
	  $this->data['class'] = $this->grade->get_class_info($this->data['principal_data']->branchid);
	  $this->data['section'] = $this->grade->get_section_info($this->data['principal_data']->branchid);
	  
	  if($this->input->post())
	  {
	    $class_id = $this->input->post("fkclass_id");
		$section_id = $this->input->post("fksection_id");
		$term = $this->input->post("term");
		$month = $this->input->post("month");
		redirect(base_url("principal/report/list_student/$class_id/$section_id/$term/$month"));	  
	  }
	  
	  $this->load->view($this->layout, $this->data);	
	}
	
	
	
	public function report_term()
	{
	  $this->data['title'] = 'Papers';
      $this->data['content'] = 'report_term';
	  $this->data['class'] = $this->grade->get_class_info($this->data['principal_data']->branchid);
	  $this->data['section'] = $this->grade->get_section_info($this->data['principal_data']->branchid);
	  
	  if($this->input->post())
	  {
	    $class_id = $this->input->post("fkclass_id");
		$section_id = $this->input->post("fksection_id");
		$term = $this->input->post("term");
		
		redirect(base_url("principal/report/list_student_term/$class_id/$section_id/$term/"));	  
	  }
	  
	  $this->load->view($this->layout, $this->data);	
	}
	
	
	public function list_student($class_id , $section_id , $term , $month)
	{
	  $this->data['title'] = 'Papers';
      $this->data['content'] = 'report_month';
	  $this->data['class'] = $this->grade->get_class_info($this->data['principal_data']->branchid);
	  $this->data['section'] = $this->grade->get_section_info($this->data['principal_data']->branchid);
	  $this->data['student'] = $this->grade->get_student($this->data['principal_data']->branchid , $class_id , $section_id);
	  $this->data['class_id'] = $class_id;
	  $this->data['section_id'] = $section_id;
	  $this->data['term'] = $term;
	  $this->data['month'] = $month;
	  
	 $this->load->view($this->layout, $this->data);	
	}
	
	public function list_student_term($class_id , $section_id , $term)
	{
	  $this->data['title'] = 'Papers';
      $this->data['content'] = 'report_term';
	  $this->data['class'] = $this->grade->get_class_info($this->data['principal_data']->branchid);
	  $this->data['section'] = $this->grade->get_section_info($this->data['principal_data']->branchid);
	  $this->data['student'] = $this->grade->get_student($this->data['principal_data']->branchid , $class_id , $section_id);
	  $this->data['class_id'] = $class_id;
	  $this->data['section_id'] = $section_id;
	  $this->data['term'] = $term;
	  
	  
	 $this->load->view($this->layout, $this->data);	
	}
	
}