<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Progress extends MY_Controller {

    public $site = 'EMITSOL International School | Principal';
    public $layout = 'principal/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principal_logged_in')) {
            redirect('principal/auth');
        }
            
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
		$this->load->model('common_model', 'CommonModel');
		$this->data['principal_data'] = $this->CommonModel->get_row('principal', $this->session->userdata('principal_id')); 
    }

    public function index() {
        $this->data['title'] = 'Progress Report | Home';
		$this->data['content'] = 'progress';
		$this->data['classes']  = $this->CommonModel->get_all_rows('classes'); 
		$this->data['sections']  = $this->CommonModel->get_all_rows('sections'); 
        $this->load->view($this->layout, $this->data);
    }
	public function get_students()
	{
		$class_name   = $this->input->post('classid');
		$section_name = $this->input->post('sectionid');
		$students = $this->CommonModel->get_students($class_name,$section_name); 
		$html = '';
		if($students)
		{
			$html = '';
			foreach ($students as $s) 
			{
				$s->remarks = $this->CommonModel->getProgressReport($s->GR_number);
					$html.= '<tr>
					<td valign="top">'.$s->GR_number.'</td>
					<td valign="top">'.$s->name.'</td>
						<td valign="top">'.$s->remarks.'</td>
					</tr>';
			}
			//print_R($students);die;
		}
		else{
			$html.= '<p>No student found.</p>';
		}
		
		echo $html;
	}
}