<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Grading extends MY_Controller {

    public $site = 'EMITSOL International School | Parents';
    public $layout = 'principal/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principal_logged_in')) {
            redirect('principal/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('principal/grading_model', 'grade');
		$this->load->model('common_model', 'CommonModel');
        // Get Logged Teacher
        $this->data['principal_data'] = $this->CommonModel->get_row('principal', $this->session->userdata('principal_id')); 
    }
	
  public function manage_subject()
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'manage_subject';
	$this->data['class'] = $this->grade->get_classes_info();
		
	$this->load->view($this->layout, $this->data);  
  }	
	
	
	
  public function assign_subject()
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'assign_subject';
		
	if($this->input->post())
	{
	  $this->grade->add_subject($this->data['principal_data']->branchid);
	  redirect(base_url("principal/grading/manage_subject"));	
	}
	$this->data['class'] = $this->grade->get_class_info($this->data['principal_data']->branchid);
	$this->data['subject'] = $this->grade->get_subject_info($this->data['principal_data']->branchid);
	$this->load->view($this->layout, $this->data);  
  }
  
  public function edit_assign_subject($class_id)
  {
	 $this->data['title'] = 'Papers';
     $this->data['content'] = 'edit_assign_subject';
		
	if($this->input->post())
	{
	  $this->grade->update_subject($this->data['principal_data']->branchid , $class_id);
	  redirect(base_url("principal/grading/manage_subject"));	
	}
	$this->data["form_data"] = $this->grade->get_assign_subject_info($this->data['principal_data']->branchid , $class_id);
	$this->data['class'] = $this->grade->get_class_info($this->data['principal_data']->branchid);
	$this->data['subject'] = $this->grade->get_subject_info($this->data['principal_data']->branchid);
	$this->data['class_id'] = $class_id;
	$this->load->view($this->layout, $this->data);   
  }
  
  public function manage_teacher()
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'manage_teacher';
	$this->data['teacher'] = $this->grade->get_teachers_info();
		
	$this->load->view($this->layout, $this->data);  
  }
  
  public function assign_teacher()
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'assign_teacher';
	
	if($this->input->post())
	{
	  $this->grade->add_teacher($this->data['principal_data']->branchid);
	  redirect(base_url("principal/grading/manage_teacher"));	
	}
	
	
	$this->data['class'] = $this->grade->get_class_info($this->data['principal_data']->branchid);
	$this->data['section'] = $this->grade->get_section_info($this->data['principal_data']->branchid);
	$this->data['teacher'] = $this->grade->get_teacher_info($this->data['principal_data']->branchid);
		
	$this->load->view($this->layout, $this->data);  
  }	
  
  public function edit_assign_teacher($pk_assign_tea_id)
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'edit_assign_teacher';
	
	if($this->input->post())
	{
	  $this->grade->update_teacher($pk_assign_tea_id , $this->data['principal_data']->branchid);
	  redirect(base_url("principal/grading/manage_teacher"));	
	}
	
	$this->data["form_data"] = $this->grade->get_assign_teacher_info($pk_assign_tea_id);
	$this->data['class'] = $this->grade->get_class_info($this->data['principal_data']->branchid);
	$this->data['section'] = $this->grade->get_section_info($this->data['principal_data']->branchid);
	$this->data['teacher'] = $this->grade->get_teacher_info($this->data['principal_data']->branchid);
		
	$this->load->view($this->layout, $this->data);  
  }	
	
}