<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Fee extends MY_Controller {

    public $site = 'EMITSOL International School | Principal';
    public $layout = 'principal/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principal_logged_in')) {
            redirect('principal/auth');
        }
            
        // Prepare Data
		$this->load->model('principal/accountant_model', 'AccountantModel');
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
		$this->load->model('common_model', 'CommonModel');
		$this->data['principal_data'] = $this->CommonModel->get_row('principal', $this->session->userdata('principal_id')); 
    }

    public function index() {
        $this->data['title'] = 'Fee Alerts | Home';
		$this->data['content'] = 'fee';
		$this->data['classes']  = $this->CommonModel->get_all_rows('classes'); 
		$this->data['sections']  = $this->CommonModel->get_all_rows('sections'); 
		$this->data['stdfee'] = $this->AccountantModel->getStudentfee();
        $this->load->view($this->layout, $this->data);
    }
	public function get_students()
	{
		$class_name   = $this->input->post('classid');
		$section_name = $this->input->post('sectionid');
		$students = $this->CommonModel->get_students($class_name,$section_name); 
		$html = '';
		if($students)
		{
			$html = '';
			foreach ($students as $s) 
			{
				$fee = $this->AccountantModel->checkStudentfeeforCurrentMonth($s->GR_number);
				if(!$fee)
				{
					$html.= '<tr>
					<td valign="top">'.$s->GR_number.'</td>
					<td valign="top">'.$s->name.'</td>
					<td valign="top">'.$s->PR_number.'</td>
					</tr>';
				}
			}
		}
		else{
			$html.= '<p>No student found.</p>';
		}
		
		echo $html;
	}
	function print_fee($classid,$sectionid) 
	{
        $this->load->library('mpdf/mpdf');
		$students = $this->CommonModel->get_students($classid,$sectionid); 
		if($students)
		{
			foreach ($students as $s) 
			{
				$fee = $this->AccountantModel->checkStudentfeeforCurrentMonth($s->GR_number);
				if($fee)
				{
					unset($s);
				}
			}
		}
		$this->data['fee_listing'] = $students;
		$html = $this->load->view('principal/fee_print', $this->data, true);
		$mpdf = new mPDF('ar-s', 'A4', '', 'Arial', 16, 16, 12, 12, 9, 9);
		// $html = iconv("windows-1256","UTF-8//IGNORE",$html);
		$mpdf->SetDisplayMode('fullpage');
		$mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
		// LOAD a stylesheet
		$stylesheet = file_get_contents('./assets/css/pdf.css');
		$mpdf->WriteHTML($stylesheet, 1);    // The parameter 1 tells that this is css/style only and no body/html/text
		//$mpdf->SetHTMLFooter($footer);
		$mpdf->SetFooter($this->data['settings']->site_name . '|{PAGENO}|' . date(DATE_RFC822));
		$mpdf->WriteHTML($html, 2);

		$file_name = date('Y_m_d_His') . '_fee_list.pdf';
		$mpdf->Output($file_name, 'I'); // F = Move to Directory, I = View, D = Download    
    }
}