<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class AddMonthly extends MY_Controller {

    public $site = 'EMITSOL International School | Principal';
    public $layout = 'principal/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principal_logged_in')) {
            redirect('principal/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('principal/accountant_model', 'AccountantModel');
		$this->data['principal_data'] = $this->CommonModel->get_row('principal', $this->session->userdata('principal_id')); 
        // Get Logged User
    }

    public function index() {
        $this->data['title'] = 'Monthly Fee | Home';
		$this->data['content'] = 'monthly_fee';
		if($_POST)
		{
			$post['classid'] = $_POST['classid'];
			$post['amount'] = $_POST['amount'];
			$post['type'] = 'monthly_fee';
			$this->AccountantModel->addMonthlyfee($post); 
			$this->data['insert'] = 'yes';
		}
		$this->data['classes'] = $this->AccountantModel->getClasses(); 
		$this->data['monthlyfee'] = $this->AccountantModel->getMonthlyfee();
        $this->load->view($this->layout, $this->data);
    }	
	public function edit($id)
	{
		$this->data['title'] = 'Monthly Fee | Home';
		$this->data['content'] = 'monthlyfee_edit';
		if($_POST)
		{
			$post['classid'] = $_POST['classid'];
			$post['amount'] = $_POST['amount'];
			$post['type'] = 'monthly_fee';
			$this->AccountantModel->updateMonthlyfee($post,$id); 
			$this->data['insert'] = 'yes';
		}
		$this->data['classes'] = $this->AccountantModel->getClasses(); 
		$this->data['monthlyfee'] = $this->AccountantModel->getMonthlyfee($id);
        $this->load->view($this->layout, $this->data);
	}
}