<?php



if (!defined('BASEPATH'))

    exit('No direct script access allowed');



class Ranking extends MY_Controller {



    public $site = 'EMITSOL International School | Parents';

    public $layout = 'parents/layout';

    public $data = array();



    public function __construct() {

        parent::__construct();



        // If user not logged in take user out from here

        if (!$this->session->userdata('parent_logged_in')) {

            redirect('parents/auth');

        }

            

        // Prepare Data

        $this->data['site_name'] = $this->site;

        $this->data['title'] = $this->site;

        // Load models

        $this->load->model('common_model', 'CommonModel');

		$this->load->model('parents/ranking_model', 'RankingModel');

		$this->data['parent_data'] = $this->CommonModel->get_row('parents', $this->session->userdata('parent_id')); 

    }



    public function index() 

	{

        $this->data['title'] = 'Ranking | Home';

		$this->load->model('parents/parent_model', 'ParentModel');

		$this->data['content'] = 'ranking';

		$students = $this->ParentModel->getStudent($this->data['parent_data']->PR_number);

		if($students)

		{

			foreach ($students as$key=> $std) 

			{

				$students [$key]->ranking_info = $this->RankingModel->get_students_ranking($std->GR_number); 

			}

		}

		$this->data['students'] = $students;

        $this->load->view($this->layout, $this->data);

    }

}