<?php



if (!defined('BASEPATH'))

    exit('No direct script access allowed');



class Homework extends MY_Controller {



    public $site = 'EMITSOL International School | Parents';

    public $layout = 'parents/layout';

    public $data = array();



    public function __construct() {

        parent::__construct();



        // If user not logged in take user out from here

        if (!$this->session->userdata('parent_logged_in')) {

            redirect('parents/auth');

        }

            

        // Prepare Data

        $this->data['site_name'] = $this->site;

        $this->data['title'] = $this->site;

        // Load models

        $this->load->model('common_model', 'CommonModel');

		$this->load->model('parents/homework_model', 'HomeworkModel');

		$this->load->model('parents/parent_model', 'ParentModel');

		// Get Logged User

        $this->data['parent_data'] = $this->CommonModel->get_row('parents', $this->session->userdata('parent_id')); 

    }



    public function index() {

        $this->data['title'] = 'Homework | Student';

		$this->data['content'] = 'homework';

		$students = $this->ParentModel->getStudent($this->data['parent_data']->PR_number);

		$home_work = "";

		if($students)

		{

			foreach ($students as$key=> $std) 

			{

				$home_work[$std->stdid] = $this->HomeworkModel->getStudentHomework($std->stdid,$std->classid,$std->sectionid);

			}

		}

		$this->data['home_work'] = $home_work;

		$this->data['students'] = $students;

        $this->load->view($this->layout, $this->data);

    }

	public function notsubmitted()

	{

		$this->data['title'] = 'Homework | Student';

		$this->data['content'] = 'homework';

		$students = $this->ParentModel->getStudent($this->data['parent_data']->PR_number);

		$home_work = "";

		if($students)

		{

			foreach ($students as$key=> $std) 

			{

				$home_work[$std->stdid] = $this->HomeworkModel->notsubmitted($std->stdid);

				$attendance = $this->HomeworkModel->get_today_attendance($std->stdid);

				if($attendance)

				{

					$students[$key]->today_attendance = $attendance->status;

				}

				else{

					$students[$key]->today_attendance = "";

				}

			}

		}

		$this->data['home_work'] = $home_work;

		$this->data['students'] = $students;

        $this->load->view($this->layout, $this->data);

	}

}