<?php



if (!defined('BASEPATH'))

    exit('No direct script access allowed');



class Complaints extends MY_Controller {



    public $site = 'EMITSOL International School | Parents';

    public $layout = 'parents/layout';

    public $data = array();



    public function __construct() {

        parent::__construct();



        // If user not logged in take user out from here

        if (!$this->session->userdata('parent_logged_in')) {

            redirect('parents/auth');

        }

            

        // Prepare Data

        $this->data['site_name'] = $this->site;

        $this->data['title'] = $this->site;

        // Load models

        $this->load->model('common_model', 'CommonModel');

		$this->load->model('parents/parent_model', 'ParentModel');

		$this->load->model('parents/complaints_model', 'ComplaintsModel');

		$this->data['parent_data'] = $this->CommonModel->get_row('parents', $this->session->userdata('parent_id')); 

    }



    public function index() {

        $this->data['title'] = 'Complaints | Home';

		$this->data['content'] = 'complaints';

		$students = $this->ParentModel->getStudent($this->data['parent_data']->PR_number);

		$complaints = "";

		if($students)

		{

			foreach ($students as $std) 

			{

				$complaints[$std->name] = $this->ComplaintsModel->get_complaints($std->GR_number);

			}

		}

		$this->data['complaints'] = $complaints;

        $this->load->view($this->layout, $this->data);

    }

	public function add()

	{

		$post = $_POST;

		$post['sender'] = 'parent';

		$post['receiver'] = 'principle';

		$post['userid'] = $this->data['parent_data']->PR_number;

		$insert_id = $this->ComplaintsModel->add($post); 

		$this->data['title'] = 'Complaints | Home';

		$this->data['content'] = 'complaints';

		$this->data['insert']= $insert_id;

		$this->data['complaints'] = $this->ComplaintsModel->get_complaints($this->session->userdata['parent_id']);;

        $this->load->view($this->layout, $this->data);

	}

}