<div class="container-fluid">

    <header class="section-header">
        <div class="tbl">
            <div class="tbl-row">
                <div class="tbl-cell">
                    <h3>Mark Sheet</h3>
                    <ol class="breadcrumb breadcrumb-simple">
                        <li><a href="<?php echo base_url();?>">Home</a></li>
                        <li class="active">Mark Sheet</li>
                    </ol>
                </div>
            </div>
        </div>
    </header>

    <section class="box-typical box-typical-padding">
        <div class="row">

            <div class="col-md-12">
            <?php if(isset($message)){?>
                <div class="alert alert-success"><i class="fa fa-file-o"></i> Mark Sheet has been submitted.</div>
            <?php }?>
            
            <form method="post" action="<?php echo base_url()."teacher/marksheet/save";?>">
                <input type="hidden" class="form-control" name="teacher" value="<?=$teacher_data->teacherid?>"> 
                <div class="row">
                    <div class="col-sm-6">
                        <!--<label class="form-control-label">Year</label>-->
                        <div class="form-group">
                            <div class='input-group date datetimepicker-year'>
                                <input type="text" class="form-control" name="year" maxlength="4" placeholder="Select Year" required="required"> 
                                <span class="input-group-addon">
                                    <i class="font-icon font-icon-calend"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <!--<label class="form-control-label">Classes</label>-->
                        <div class="form-group">
                            <select class="form-control select_class" required name="class" onchange="getStudentMarks(this)">
                                <option value="">Select Class</option>
                                <?php 
                                foreach ($classes as $c) { ?>
                                <option value="<?php echo $c->classid;?>"><?php echo $c->class_name;?></option>
                                <?php }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <!--<label class="form-control-label">Months</label>-->
                        <div class="form-group">
                            <select class="form-control select_month" required name="month">
                                <option value="">Select Month</option>
                                <?php 
                                foreach ($months as $m) { ?>
                                <option value="<?php echo $m->id;?>"><?php echo $m->name;?></option>
                                <?php }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                    	<!--<label class="form-control-label">Sections</label>-->
                        <div class="form-group">
                            <select class="form-control select_section" required name="section" onchange="getStudentMarks(this)">
                                <option value="">Select Section</option>
                                <?php 
                                foreach ($sections as $s) { ?>
                                <option value="<?php echo $s->sectionid;?>"><?php echo $s->section_name;?></option>
                                <?php }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                    	<!--<label class="form-control-label">Exams</label>-->
                        <div class="form-group">
                            <select class="form-control select_exam" required name="exam">
                                <option value="" data-key="" data-term="" data-format="">Select Exam</option>
                                <?php 
                                foreach ($exams as $e) { ?>
                                <option value="<?php echo $e->id;?>" data-key="<?php echo $e->key;?>" data-term="<?php echo $e->term;?>" data-format="<?php echo $e->format;?>"><?php echo $e->name;?></option>
                                <?php }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                    	<!--<label class="form-control-label">Subjects</label>-->
                        <div class="form-group">
                            <select class="form-control select_subject" required name="subject" onchange="getStudentMarks(this)">
                                <option value="">Select Subject</option>
                                <?php 
                                foreach ($subjects as $s) { ?>
                                <option value="<?php echo $s->subjectid;?>"><?php echo $s->subject_name;?></option>
                                <?php }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-3 quiz_marks_container questions_max_marks_container">
                        <div class="row">
                            <label class="form-control-label col-sm-12">Quiz Max Marks</label>
                            <div class="form-group col-sm-12">
                                <input type="number" class="form-control quiz_marks_fields" name="questions_max_marks" placeholder="Enter Quiz Max Marks" step="any" min="0" required="required"> 
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3 quiz_marks_container questions_passing_marks_container">
                        <div class="row">
                            <label class="form-control-label col-sm-12">Quiz Passing Marks</label>
                            <div class="form-group col-sm-12">
                                <input type="number" class="form-control quiz_marks_fields" name="questions_passing_marks" placeholder="Enter Quiz Passing Marks" step="any" min="0" required="required"> 
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 quiz_marks_container class_work_max_marks_container">
                        <div class="row">
                            <label class="form-control-label col-sm-12">Class Work Max Marks</label>
                            <div class="form-group col-sm-12">
                                <input type="number" class="form-control quiz_marks_fields" name="class_work_max_marks" placeholder="Enter Class Work Max Marks" step="any" min="0" required="required"> 
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 quiz_marks_container123 class_work_passing_marks_container hidden">
                        <div class="row">
                            <!--<label class="form-control-label col-sm-2">Class Work Passing Marks</label>-->
                            <div class="form-group col-sm-12">
                                <input type="number" class="form-control quiz_marks_fields" name="class_work_passing_marks" placeholder="Enter Class Work Passing Marks" step="any" min="0" required="required"> 
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 exam_marks_container exam_max_marks_container hidden">
                        <div class="row">
                            <label class="form-control-label col-sm-12">Exam Max Marks</label>
                            <div class="form-group col-sm-12">
                                <input type="number" class="form-control exam_marks_fields" name="exam_max_marks" placeholder="Enter Exam Max Marks" step="any" min="0"> 
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 exam_marks_container exam_passing_marks_container hidden">
                        <div class="row">
                            <label class="form-control-label col-sm-12">Exam Passing Marks</label>
                            <div class="form-group col-sm-12">
                                <input type="number" class="form-control exam_marks_fields" name="exam_passing_marks" placeholder="Enter Exam Passing Marks" step="any" min="0"> 
                            </div>
                        </div>
                    </div>
                </div>
                <div class="clearfix">&nbsp;</div>
                <div class="row">
                	<div class="col-sm-12" id="students_container">
                    </div>
                </div>
                <!--<div class="clearfix">&nbsp;</div>
                <div class="row">
                    <div class="col-sm-12 text-center">
                        <input type="submit" class="btn btn-success" value="Submit"/>
                    </div>
                </div>-->                    
            </form>                        
            </div>
        </div>
    </section>
</div><!--.container-fluid-->
<script>
$(document).ready(function() {
	$('.datetimepicker-year').datetimepicker({
		viewMode: 'years',
		format: 'YYYY'
	}).on('dp.change', function (e) {
        getStudentMarks();
    });
	
	//getStudentMarks();
	$(document).on('keyup','.questions_marks,.class_work_marks,.exam_marks',function(){	
		max_marks = 0;
		total_marks = 0;
		var id = $(this).data('id');
		exam_marks = $('#exam_marks'+id).val();
		if( exam_marks == "" ) exam_marks = 0;
		questions_marks = $('#questions_marks'+id).val();
		if( questions_marks == "" ) questions_marks = 0;
		class_work_marks = $('#class_work_marks'+id).val();
		if( class_work_marks == "" ) class_work_marks = 0;
		
		exam_max_marks = $('input[name="exam_max_marks"]').val();
		if( exam_max_marks == "" ) exam_max_marks = 0;
		questions_max_marks = $('input[name="questions_max_marks"]').val();
		if( questions_max_marks == "" ) questions_max_marks = 0;
		class_work_max_marks = $('input[name="class_work_max_marks"]').val();
		if( class_work_max_marks == "" ) class_work_max_marks = 0;
		//exam_max_marks = $('input[name="exam_max_marks"]').val();
		/*if($(this).hasClass('exam_marks'))
		{
			total_marks = exam_marks;
			max_marks = $('input[name="exam_max_marks"]').val();
		}*/
		//questions_max_marks = $('input[name="questions_max_marks"]').val();
		/*if($(this).hasClass('questions_marks'))
		{
			total_marks = parseFloat(total_marks)+parseFloat(questions_marks);
			max_marks = parseFloat(max_marks)+parseFloat($('input[name="questions_max_marks"]').val());
		}*/
		//class_work_max_marks = $('input[name="class_work_max_marks"]').val();
		/*if($(this).hasClass('class_work_marks'))
		{
			total_marks = parseFloat(total_marks)+parseFloat(class_work_marks);
			max_marks = parseFloat(max_marks)+parseFloat($('input[name="class_work_max_marks"]').val());
		}*/
		if($("select[name='exam']").find(':selected').data('format') == "quiz")
		{
			total_marks = parseFloat(questions_marks)+parseFloat(class_work_marks);
			max_marks = parseFloat(questions_max_marks)+parseFloat(class_work_max_marks);
		}
		else
		{
			total_marks = parseFloat(exam_marks)+parseFloat(questions_marks)+parseFloat(class_work_marks);
			max_marks = parseFloat(exam_max_marks)+parseFloat(questions_max_marks)+parseFloat(class_work_max_marks);
		}
			
		if(parseFloat(total_marks) > parseFloat(max_marks))
		alert("Total marks should be less than maximum marks");
		else
		$('#total_marks'+id).text(total_marks)
		console.log("total_marks:"+total_marks+"/max_marks:"+max_marks);
    });
	
	$(document).on('change',"select[name='exam']",function(){	
		getStudentMarks();
		var exam_format = $(this).find(':selected').data('format');
		if(exam_format == "quiz")
		{
			$(".exam_marks_container").addClass('hidden');
			$(".quiz_marks_container").removeClass('hidden');
			$(".exam_marks_container").find('.exam_marks_fields').removeAttr('required');
			$(".quiz_marks_container").find('.quiz_marks_fields').attr('required','required');
		}
		else
		{
			//$(".quiz_marks_container").addClass('hidden');
			$(".exam_marks_container").removeClass('hidden');
			//$(".quiz_marks_container").find('.exam_marks_fields').removeAttr('required');
			$(".exam_marks_container").find('.quiz_marks_fields').attr('required','required');
		}
	})
})

function getStudentMarks(ele)
{
	var year = $("input[name='year']").val();
	var exam = $("select[name='exam']").val();
	var mark = $("select[name='mark']").val();
	var month = $("select[name='month']").val();
	var classid = $("select[name='class']").val();
	var section = $("select[name='section']").val();
	var subject = $("select[name='subject']").val();
	//var total_marks = $("input[name='total_marks']").val();
	/*var exam_max_marks = $("input[name='exam_max_marks']").val();
	var exam_passing_marks = $("input[name='exam_passing_marks']").val();
	var questions_max_marks = $("input[name='questions_max_marks']").val();
	var questions_passing_marks = $("input[name='questions_passing_marks']").val();
	var class_work_max_marks = $("input[name='class_work_max_marks']").val();
	var class_work_passing_marks = $("input[name='class_work_passing_marks']").val();*/
	var exam_key = $("select[name='exam']").find(':selected').data('key');
	var exam_term = $("select[name='exam']").find(':selected').data('term');
	var exam_format = $("select[name='exam']").find(':selected').data('format');
	if(exam_key == "")var exam_key = "first_term_quiz";if(exam_term == "")var exam_term = "first";if(exam_format == "")var exam_format = "quiz";
	/*if(exam_format == "quiz")
	{
		$(".exam_marks_container").addClass('hidden');
		$(".quiz_marks_container").removeClass('hidden');
		$(".exam_marks_container").find('.exam_marks_fields').removeAttr('required');
		$(".quiz_marks_container").find('.quiz_marks_fields').attr('required','required');
	}
	else
	{
		$(".quiz_marks_container").addClass('hidden');
		$(".exam_marks_container").removeClass('hidden');
		$(".quiz_marks_container").find('.exam_marks_fields').removeAttr('required');
		$(".exam_marks_container").find('.quiz_marks_fields').attr('required','required');
	}*/
	$.ajax({
		type: 'POST',
		dataType:'json',
		url: '<?php echo base_url()."teacher/marksheet/getStudentMarks";?>',
		data: {year:year,classid:classid,month:month,section:section,exam:exam,subject:subject},
		success: function(students)
		{
			console.log(students);
			var html = '';
			var colspan = 3;
			var exam_max_marks = "";
			var exam_passing_marks = "";
			var questions_max_marks = "";
			var questions_passing_marks = "";
			var class_work_max_marks = "";
			var class_work_passing_marks = "";
			var exam_marks_display = "none";
			/*var first_term_quiz = false;
			var first_term_exam = false;
			var second_term_quiz = false;
			var second_term_exam = false;
			if(exam_key == "first_term_quiz"){var colspan = 3;var first_term_quiz = true;}
			if(exam_key == "first_term_exam"){var colspan = 4;var first_term_exam = true;}
			if(exam_key == "second_term_quiz"){var colspan = 3;var second_term_quiz = true;}
			if(exam_key == "second_term_exam"){var colspan = 3;var second_term_exam = true;}*/
			
			if(exam_format == "exam"){var colspan = 4;var exam_marks_display = "table-cell";}
			if(students)
			{
				html += '<table border="0" cellspacing="0" cellpadding="0" class="table table-hover table-stripped  table-bordered">';
				html += '	<thead>';
				html += '		<tr><th rowspan="2" style="vertical-align: middle;text-align:center">Name</th><th colspan="'+colspan+'" style="text-align:center">Marks</th></tr>';
				//html += '		<tr><th style="text-align:center">Q</th><th style="text-align:center">CW</th><th style="text-align:center">Total Marks</th></tr>';
				html += '		<tr>';
				html += '			<th style="text-align:center">Q</th>';
				html += '			<th style="text-align:center">CW</th>';
				html += '			<th style="text-align:center;display:'+exam_marks_display+'">TM</th>';
				html += '			<th style="text-align:center" width="15%;">Total Marks</th>';
				html += '		</tr>';
				html += '	</thead>';
				html += '	<tbody>';
				$.each(students, function(i, student) {
					mark_id = "";
					studentid = "";
					exam_marks = "";
					questions_marks = "";
					class_work_marks = "";
					if(student.stdid != null)studentid = student.stdid;
					if(student.mark_id != null)mark_id = student.mark_id;
					if(exam_term == "first")
					{
						if(student.first_term_exam_marks != null)exam_marks = student.first_term_exam_marks;
						if(student.first_term_exam_max_marks != null)exam_max_marks = student.first_term_exam_max_marks;
						if(student.first_term_exam_passing_marks != null)exam_passing_marks = student.first_term_exam_passing_marks;
						if(student.first_term_questions_marks != null)questions_marks = student.first_term_questions_marks;
						if(student.first_term_questions_max_marks != null)questions_max_marks = student.first_term_questions_max_marks;
						if(student.first_term_questions_passing_marks != null)questions_passing_marks = student.first_term_questions_passing_marks;
						if(student.first_term_class_work_marks != null)class_work_marks = student.first_term_class_work_marks;
						if(student.first_term_class_work_max_marks != null)class_work_max_marks = student.first_term_class_work_max_marks;
						if(student.first_term_class_work_passing_marks != null)class_work_passing_marks = student.first_term_class_work_passing_marks;
					}
					else
					{
						if(student.second_term_exam_marks != null)exam_marks = student.second_term_exam_marks;
						if(student.second_term_exam_max_marks != null)exam_max_marks = student.second_term_exam_max_marks;
						if(student.second_term_exam_passing_marks != null)exam_passing_marks = student.second_term_exam_passing_marks;
						if(student.second_term_questions_marks != null)questions_marks = student.second_term_questions_marks;
						if(student.second_term_questions_max_marks != null)questions_max_marks = student.second_term_questions_max_marks;
						if(student.second_term_questions_passing_marks != null)questions_passing_marks = student.second_term_questions_passing_marks;
						if(student.second_term_class_work_marks != null)class_work_marks = student.second_term_class_work_marks;
						if(student.second_term_class_work_max_marks != null)class_work_max_marks = student.second_term_class_work_max_marks;
						if(student.second_term_class_work_passing_marks != null)class_work_passing_marks = student.second_term_class_work_passing_marks;
					}
					if(exam_format == "quiz")
					total_marks = parseFloat(parseFloat(questions_marks)+parseFloat(class_work_marks)).toFixed(2);
					else
					total_marks = parseFloat(parseFloat(questions_marks)+parseFloat(class_work_marks)+parseFloat(exam_marks)).toFixed(2);
					
					html += '		<tr id="row'+i+'">';
					html += '			<td style="text-align:left">';
					html += '				<input type="hidden" name="mark_id[]" value="'+mark_id+'">';
					html += '				<input type="hidden" name="exam_term[]" value="'+exam_term+'">';
					html += '				<input type="hidden" name="student[]" value="'+studentid+'">';
					html += '				'+student.name;
					html += '			</td>';
					html += '			<td style="text-align:center"><input type="number" class="form-control questions_marks" name="questions_marks[]" value="'+Math.abs(questions_marks)+'" step="any" min="0" data-id="'+i+'" id="questions_marks'+i+'"></td>';
					html += '			<td style="text-align:center"><input type="number" class="form-control class_work_marks" name="class_work_marks[]" value="'+Math.abs(class_work_marks)+'" step="any" min="0" data-id="'+i+'" id="class_work_marks'+i+'"></td>';
					html += '			<td style="text-align:center;display:'+exam_marks_display+'"><input type="number" class="form-control exam_marks" name="exam_marks[]" value="'+Math.abs(exam_marks)+'" step="any" min="0" data-id="'+i+'" id="exam_marks'+i+'"></td>';
					if(isNaN(total_marks))total_marks = "";
					html += '			<td style="text-align:center;vertical-align:middle" id="total_marks'+i+'">'+total_marks+'</td>';
					html += '		</tr>';
				});
				html += '	</tbody>';
				html += '</table>';
				html += '<div class="clearfix">&nbsp;</div>';
				html += '<div class="row"><div class="col-sm-12 text-center"><input type="submit" class="btn btn-success" value="Submit"/></div></div>';
			}
			else
			{
				html +='<p class="text-center">No students found</p>';
			}
			$("#students_container").html(html);
			$('input[name="exam_max_marks"]').val(exam_max_marks);
			$('input[name="exam_passing_marks"]').val(exam_passing_marks);
			$('input[name="questions_max_marks"]').val(questions_max_marks);
			$('input[name="questions_passing_marks"]').val(questions_passing_marks);
			$('input[name="class_work_max_marks"]').val(class_work_max_marks);
			$('input[name="class_work_passing_marks"]').val(class_work_passing_marks);
		},
	});
}
</script>