<div class="container-fluid">

    <header class="section-header">
        <div class="tbl">
            <div class="tbl-row">
                <div class="tbl-cell">
                    <h3>Add Weekly Lesson Plan</h3>
                    <ol class="breadcrumb breadcrumb-simple">
                        <li><a href="<?php echo base_url();?>">Home</a></li>
                        <li class="active">Weekly Lesson Plan</li>
                    </ol>
                </div>
            </div>
        </div>
    </header>
  
    <section class="box-typical box-typical-padding">
        <div class="row">
  
            <div class="col-md-12">
				<?php if(isset($insert)){?>
                    <div class="alert alert-success"><i class="fa fa-file-o"></i> Your weekly lesson plan has been added successfully in our record.</div>
                <?php }else{?>
                    <div class="alert alert-info">Please contact us in case of any technical issue, suggestion, or help in application services. or missing information.</div>
                <?php }?>
                <form method="post" action="<?php echo base_url()."teacher/complaints/add";?>">
                    
                    <div class="form-group row">
                        <label class="col-sm-2 form-control-label">Class</label>
                        <div class="col-sm-10">
                            <p class="form-control-static">
                            	<select class="form-control select2 select_section" name="classid">
                                    <option value="">Select</option>
                                    <?php 
                                    if(!empty($classes))
                                    {
                                        foreach ($classes as $c) { ?>
                                            <option value="<?php echo $c->classid;?>"><?php echo $c->class_name;?></option>
                                        <?php }
                                    }
                                    ?>
                                </select>
                            </p>
                        </div>
                    </div>
                    
                    <div class="form-group row">
                        <label class="col-sm-2 form-control-label">Section</label>
                        <div class="col-sm-10">
                            <p class="form-control-static">
                            	<select class="form-control select2 select_section" name="sectionid">
                                    <option value="">Select</option>
                                    <?php 
                                    if(!empty($sections))
                                    {
                                        foreach ($sections as $s) { ?>
                                            <option value="<?php echo $s->sectionid;?>"><?php echo $s->section_name;?></option>
                                        <?php }
                                    }
                                    ?>
                                </select>
                            </p>
                        </div>
                    </div>
                    
                    <div class="form-group row">
                        <label class="col-sm-2 form-control-label">Subject</label>
                        <div class="col-sm-10">
                            <p class="form-control-static">
                            	<select class="form-control select2 select_section" name="subjectid">
                                    <option value="">Select</option>
                                    <?php 
                                    if(!empty($subjects))
                                    {
                                        foreach ($subjects as $s) { ?>
                                            <option value="<?php echo $s->subjectid;?>"><?php echo $s->subject_name;?></option>
                                        <?php }
                                    }
                                    ?>
                                </select>
                            </p>
                        </div>
                    </div>
                    
                    <div class="form-group row">
                        <label for="exampleSelect" class="col-sm-2 form-control-label">Details</label>
                        <div class="col-sm-10">
                            <textarea rows="4" name="description" class="form-control texteditor"></textarea>
                        </div>
                    </div>
                    
                    <div class="form-group row">
                        <label class="col-sm-2 form-control-label">Date</label>
                        <div class="col-sm-10">
                            <p class="form-control-static">
                            <div class='input-group date datetimepicker-datetime'>
                                <input type="text" class="form-control" value="<?php echo date('m/d/Y');?>" name="datetime" maxlength="10">
                                <span class="input-group-addon">
                                    <i class="font-icon font-icon-calend"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-sm-2"></div>
                        <div class="col-sm-10">
                            <input type="submit" class="btn btn-success" value="Submit" />
                        </div>
                    </div>                    
                </form>                        
            </div>
            
        </div>
    </section>
    
	<section class="box-typical box-typical-padding">
		<h2>Weekly Lesson Plan History</h2>
        <div class="row">
            <div class="col-md-12">
                <?php if($weeklylessonplans){ ?>
                <table border="0" cellspacing="0" cellpadding="0" class="table table-hover table-stripped  table-bordered">
                  <thead>
                  <tr>
                    <th valign="top">Class</th>
                    <th valign="top">Section</th>  
                    <th valign="top">Subject</th> 
                    <!--<th valign="top">Details</th>-->
                    <th valign="top">Date</th> 
                    <td valign="top">Status</td>
                  </tr>
                  </thead>
                  <tbody>
                       <?php if($weeklylessonplans){
                       foreach ($weeklylessonplans as $weeklylessonplan)
                            { 
                            ?>
                            <tr>
                                 <td valign="top"><?php echo $weeklylessonplan->class_name;?></td>
                                 <td valign="top"><?php echo $weeklylessonplan->section_name;?></td>
                                 <td valign="top"><?php echo $weeklylessonplan->subject_name;?></td>
                                 <!--<td valign="top"><?php echo $weeklylessonplan->details;?></td>-->
                                 <td valign="top"><?php echo date('d M Y',  strtotime($weeklylessonplan->date));?></td>
                                 <td valign="top">Status</td>
                            </tr>
                       		<?php 
                       		}
					   }
					   ?>
                  </tbody>
                </table>
                <?php }else{ ?>
                <p>No lesson plan from teacher.</p>
                <?php }?>
            </div>
        </div>
    </section>
  
</div><!--.container-fluid-->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.1/js/select2.min.js"></script>
<script>
$(document).ready(function() {
	//var calendar = $.calendars.instance('Islamic', 'ar');
	//$('#field-father_iqama_expiry').calendarsPicker({calendar: calendar});
	//$('#field-mother_iqama_expiry').calendarsPicker({calendar: calendar});
	//$('#field-iqama_expiry').calendarsPicker({calendar: calendar});
	//$('#field-license_expiry').calendarsPicker({calendar: calendar});
	//$('#field-driving_license_expiry').calendarsPicker({calendar: calendar});

	$('.datetimepicker-datetime').datetimepicker({
		format: 'L'
	});
	
	$(".select_section").select2({});
});
</script>