<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Onlineresults extends MY_Controller {

    public $site = 'Al Hukama International School | Principle';
    public $layout = 'principle/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principle_logged_in')) {
            redirect('principle/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
		$this->load->model('principle/online_model', 'OnlineModel');
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->data['principle_data'] = $this->CommonModel->get_row('principle', $this->session->userdata('principle_id')); 
		
    }
	public function resultlisting($classid = '',$sectionid = '')
	{
		if($classid && $sectionid)
		{
			$this->OnlineModel->delete_results($classid,$sectionid);
			$this->data['insert'] = 'yes';
		}
		$this->data['results'] = $this->OnlineModel->get_results();
		$this->data['content']  = 'result_listing';
		$this->load->view($this->layout, $this->data);
	}

	public function index() {
        $this->data['title'] = 'Online Results | Home';
		$this->data['content'] = 'online';
		$this->data['classes']  = $this->CommonModel->get_all_rows('classes'); 
		$this->data['sections']  = $this->CommonModel->get_all_rows('sections'); 
//		$this->data['classes']  = $this->CommonModel->get_all_rows_by_branchid('classes'); 
//		$this->data['sections']  = $this->CommonModel->get_all_rows_by_branchid('sections'); 
		
		if($_FILES)
		{
			$insert_data['classid'] = $_POST['classid'];
			$insert_data['sectionid'] = $_POST['sectionid'];
			foreach ($_FILES as $gr_number=> $file) 
			{
				
				if($file['name'])
				{
					$gr_number = explode("_", $gr_number);
					$gr_number = $gr_number[1];
					$file_name = $this->do_uploadfile($file,$gr_number);
					$this->data['insert'] = 'yes';
					$insert_data['gr_number'] = $gr_number;
					$insert_data['file'] = $file_name;
					$insert_data['date'] = date('Y-m-d');
					$this->OnlineModel->delete_old_result($gr_number);
					$this->CommonModel->insert('online_results',$insert_data);			
				}
			}
		}
        $this->load->view($this->layout, $this->data);
    }
	public function get_students()
	{
		$class_name   = $this->input->post('classid');
		$section_name = $this->input->post('sectionid');
		$students = $this->CommonModel->get_students($class_name,$section_name); 
		$html = '';
		if($students)
		{
			$html = '<h3>Student Listing</h3><br>';
			$html.= '<div class="row">
						<div class="col-md-12">
							<table border="0" cellspacing="0" cellpadding="0" width="100%" class="table table-bordered table-striped table-hover">
								<thead>
									<tr>
										<th valign="top"><strong>Student</strong></th>
										<th valign="top"><strong>Browse</strong></th>
									</tr>
								</thead>
								<tbody>';
								foreach ($students as $s) 
								{
									$html.= '<tr>
										<td valign="top">'.$s->name.' ( '.$s->GR_number.' )</td>
										<td valign="top"><input type="file" name="file_'.$s->GR_number.'" value=""></td>
										</tr>';
								}
			$html.= '<input type="hidden" name="classid" value="'.$class_name.'">';
			$html.= '<input type="hidden" name="sectionid" value="'.$section_name.'">';
			$html.= '</tbody>
							</table>
							<button class="btn" type="submit">Submit</button>
						</div>
					</div>';
		}
		else{
			$html.= '<p>No student found.</p>';
		}
		
		echo $html;
	}
	function do_uploadfile($file,$gr_number)
    {
		$allowedExts = array("pdf", "doc", "docx");
		$ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION)) ;
		$file_name = "";
		if(isset($ext))
		{
			if (in_array($ext, $allowedExts))
			{
				if ($file["error"] > 0)
				{
				   echo "Return Code: " . $file["document"]["error"] . "<br>";die;
				}
				else
				{
				   $file_name =  $gr_number."-".time()."-". $file["name"];
				   $file = move_uploaded_file($file["tmp_name"],"assets/uploads/online_results/" .$file_name);
				}
			}
		}
		return $file_name;
	}
	function edit($classid='',$sectionid='')
	{
		if($_FILES)
		{
			foreach ($_FILES as $gr_number=> $file) 
			{
				if($file['name'])
				{
					$gr_number = explode("_", $gr_number);
					$gr_number = $gr_number[1];
					$id = $_POST['result_'.$gr_number];
					$classid = $_POST['classid'];
					$sectionid = $_POST['sectionid'];
					$file_name = $this->do_uploadfile($file,$gr_number);
					$this->data['insert'] = 'yes';
					$update_data['gr_number'] = $gr_number;
					$update_data['file'] = $file_name;
					$update_data['date'] = date('Y-m-d');
					$this->OnlineModel->delete_old_result($gr_number);
					$this->OnlineModel->update($update_data,$id); 
				}
				
			}
		}
		$this->data['students'] = $this->OnlineModel->get_class_students($classid,$sectionid);
		$this->data['content'] = 'results_edit';
		$this->load->view($this->layout, $this->data);
	}
	function remove_file()
	{
		$file_name = FCPATH ."assets/uploads/online_results/".$_POST['file_name'];
		$gr_number = $_POST['gr_number'];
		$this->OnlineModel->delete_old_result($gr_number);
		unlink($file_name);
	}
}