<div class="container-fluid">

    <header class="section-header">
        <div class="tbl">
            <div class="tbl-row">
                <div class="tbl-cell">
                    <h3>Set Student Fees</h3>
                    <ol class="breadcrumb breadcrumb-simple">
                        <li><a href="<?php echo base_url();?>">Home</a></li>
                        <li class="active">Set Student Fees</li>
                    </ol>
                </div>
            </div>
        </div>
    </header>
  
    <section class="box-typical box-typical-padding">
        <div class="row">
  
            <div class="col-md-12">
  
				<?php if(isset($save)){?>
                    <div class="alert alert-success"><i class="fa fa-file-o"></i> Student fees has been set.</div>
                <?php }?>
                <form method="post" action="<?php echo base_url()."accountant/setStudentFee";?>">
                    
                    <div class="form-group row">
                        <label class="col-sm-2 form-control-label">GR Number</label>
                        <div class="col-sm-10">
                            <select class="form-control select2" name="GR_number" onchange="getSetStudentFeesValueDetails(this);">
                                <option value="">Select Student</option>
                                <?php 
                                foreach ($students as $s) { ?>
                                <option value="<?php echo $s->stdid;?>"><?php echo $s->GR_number;?>&nbsp;-&nbsp;<?php echo $s->name;?></option>
                                <?php }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div id="all_std_id" style="display:none;">
                      <div class="form-group row">
                          <label class="col-sm-2 form-control-label">Student Name</label>
                          <div class="col-sm-10">
                              <input type="text" disabled class="form-control" value="" name="student_name">
                          </div>
                      </div>
                      <div class="form-group row">
                          <label class="col-sm-2 form-control-label">Class</label>
                          <div class="col-sm-10">
                              <input type="hidden" name="classid">
                              <input type="text" disabled class="form-control" value="" name="class_name">
                          </div>
                      </div>
                      <div class="form-group row">
                          <label class="col-sm-2 form-control-label">Section</label>
                          <div class="col-sm-10">
                              <input type="hidden" name="sectionid">
                              <input type="text" disabled class="form-control" value="" name="section_name">
                          </div>
                      </div>
                      <div class="form-group row hidden">
                          <label class="col-sm-2 form-control-label">Fees Type</label>
                          <div class="col-sm-10">
                              <select class="form-control select_fees_type" name="fees_type" onchange="getFeesValue(this);">
                                  <option value="">Select Fees Type</option>
                                  <?php 
                                  foreach ($fees_type_reporting as $f) { ?>
                                  <option value="<?php echo $f->id;?>"><?php echo $f->type;?>&nbsp;<?php /*?>-&nbsp;<?php echo $s->name;?><?php */?></option>
                                  <?php }
                                  ?>
                              </select>
                          </div>
                      </div>
                      <div class="form-group row fees_type_row">
                          <label class="col-sm-2 form-control-label"></label>
                          <div class="col-sm-10">
                              <input type="hidden" name="fees_type_id">
                              <input type="text" disabled class="form-control" value="" name="fees_type_value">
                          </div>
                      </div>
                      <div class="form-group row">
                          <label class="col-sm-2 form-control-label">Apply Discount (%)</label>
                          <div class="col-sm-10">
                              <input type="number" required class="form-control" value="" name="discount" onkeyup="setTotalPayable(this);">
                          </div>
                      </div>
                      <div class="form-group row">
                          <label class="col-sm-2 form-control-label">Total Payable</label>
                          <div class="col-sm-10">
                              <input type="text" disabled class="form-control" value="" name="total_payable">
                          </div>
                      </div>
                      <div class="row">
                          <div class="col-sm-12">
                              <input type="hidden" name="discount_amount">
                              <input type="hidden" name="discounted_fees_value">
                              <input type="submit" class="btn btn-success" value="Submit" />
                          </div>
                      </div>
                    </div>
                </form>                        
            </div>
        </div>
    </section>
    
	<section class="box-typical box-typical-padding">
		<h2>Student Fees</h2>
        <div class="row">
            <div class="col-md-12">
				<?php if(isset($delete)){?>
                    <div class="alert alert-success"><i class="fa fa-file-o"></i> Student fees has been deleted.</div>
                <?php }?>
                <?php if($student_fees){ ?>
                <table border="0" cellspacing="0" cellpadding="0" class="table table-hover table-stripped  table-bordered">
                  <thead>
                  <tr>
                    <th valign="top">GR number</th>
                    <th valign="top">Name</th>
                    <th valign="top">Class</th>  
                    <th valign="top">Tuition Fees</th> 
                    <th valign="top">Discount (%)</th> 
                    <th valign="top">Total Payable</th>
                    <th valign="top">Action</th> 
                  </tr>
                  </thead>
                  <tbody>
                       <?php if($student_fees){
                        foreach ($student_fees as $student_fee)
                            { 
                            $total_payable = 0;
							$fees_type_value = 0;
							$value = unserialize($student_fee->value);
							$fees_type_value = $value[$student_fee->fees_type_id]['fees_type_value'];
                            if(!empty($student_fee->discount))
                            {
                                //$total_payable = $fees_type_value - ($fees_type_value*$student_fee->discount/100);
								$total_payable = $student_fee->discounted_fees_value;
                            }
                            ?>
                            <tr>
                                 <td valign="top"><?php echo $student_fee->GR_number;?></td>
                                 <td valign="top"><?php echo $student_fee->name;?></td>
                                 <td valign="top"><?php echo $student_fee->class_name;?></td>
                                 <td valign="top"><?php echo $fees_type_value;?>&nbsp;SAR</td>
                                 <td valign="top"><?=(!empty($student_fee->discount))?abs($student_fee->discount)."%":"-";?></td>
                                 <td valign="top"><?php echo $total_payable;?>&nbsp;SAR</td>
                                 <td valign="top">
                                 	<a href="<?php echo base_url()."accountant/setStudentFee/edit/".$student_fee->sfdid;?>" class="btn btn-sm btn-success"><i class="fa fa-edit"></i></a>&nbsp;
                                    <a href="<?php echo base_url()."accountant/setStudentFee/delete/".$student_fee->sfdid;?>" class="btn btn-sm btn-danger"><i class="fa fa-trash-o"></i></a>
                                 </td>
                             </tr>
                      <?php 
                       }}?>
                  </tbody>
                </table>
                <?php }else{ ?>
                <p>No Student Fees found.</p>
                <?php }?>
            </div>
        </div>
	</section>
</div><!--.container-fluid-->

<script>
    function getFeesValue(ele)
    {
		$('.fees_type_row').find('label').html($(ele).find(':selected').data('fees_type_name'));
		$('.fees_type_row').find('input[name="fees_type_id"]').val($(ele).find(':selected').data('fees_type_id'));
		$('.fees_type_row').find('input[name="fees_type_value"]').val($(ele).find(':selected').data('fees_type_value'));
    }
	
	function setTotalPayable(ele)
    {
		total_payable = "";
		discount_amount = "";
		discount = $(ele).val();
		if(discount != "" && !isNaN(discount))
		{
			fees_type_value = $('input[name="fees_type_value"]').val();
			if(fees_type_value != "" && !isNaN(fees_type_value))
			{
				discount_amount = parseFloat(fees_type_value)*parseFloat(discount)/parseFloat(100);
				total_payable = parseFloat(fees_type_value) - parseFloat(discount_amount);
			}
			
		}
		
		$('input[name="total_payable"]').val(total_payable);
		$('input[name="discount_amount"]').val(discount_amount);
		$('input[name="discounted_fees_value"]').val(total_payable);
    }
	
	function getSetStudentFeesValueDetails(ele)
    {
        var stdid = $(ele).val();
        $.ajax({
            type: 'POST',
            dataType:'json',
            url: '<?php echo base_url()."accountant/SetStudentFee/getSetStudentFeesValueDetails";?>',
            data: {stdid:stdid},
            success: function(data)
            {
                console.log(data);
				/*if(data.branchid == 1)
                {
                    $('#branchid').val('Girls Branch');
                }
                else
                {
                    $('#branchid').val('Boys Branch');
                }*/
                
                $('input[name="classid"]').val(data.classid);
				$('input[name="sectionid"]').val(data.sectionid);
				$('input[name="student_name"]').val(data.name);
				$('input[name="class_name"]').val(data.class_name);
				$('input[name="section_name"]').val(data.section_name);
				var fees_type_options = '<option value="">Select Fees Type</option>';
				if(data.value !="" && data.value !=null)
				{
					var fees_type_count = (Object.keys(data.value).length);
					console.log(fees_type_count);
					if(fees_type_count > 1)
					{
						$.each( data.value, function( i, val ) {
						  fees_type_options += '<option value="'+val.fees_type_id+'" data-value="'+val.fees_type_value+'">'+val.fees_type_name+'</option>';
						});
						$('select[name="fees_type"]').html(fees_type_options);
					}
					else
					{
						$.each( data.value, function( i, val ) {
						  //$('.fees_type_row').find('label').html(val.fees_type_name);
						  $('.fees_type_row').find('label').html("Actual "+val.fees_type_name);
						  $('.fees_type_row').find('input[name="fees_type_id"]').val(val.fees_type_id);
						  $('.fees_type_row').find('input[name="fees_type_value"]').val(val.fees_type_value);
						});
					}
				}
				
                $('#all_std_id').show();
            },
        });
    }
</script>