<div class="container-fluid">

    <header class="section-header">
        <div class="tbl">
            <div class="tbl-row">
                <div class="tbl-cell">
                    <h3>Mark Sheet</h3>
                    <ol class="breadcrumb breadcrumb-simple">
                        <li><a href="<?php echo base_url();?>">Dashboard</a></li>
                        <li class="active">Mark Sheet</li>
                    </ol>
                </div>
            </div>
        </div>
    </header>

    <section class="box-typical box-typical-padding">
        <div class="row">

            <div class="col-md-12">
            <?php if(isset($message)){?>
                <div class="alert alert-success"><i class="fa fa-file-o"></i> Mark Sheet report has been generated.</div>
            <?php }?>
            
            <form method="post" action="<?php echo base_url()."admin/marksheet";?>">
                
                <div class="row">
                    <div class="col-sm-6">
                        <!--<label class="form-control-label">Year</label>-->
                        <div class="form-group">
                            <div class='input-group date datetimepicker-year'>
                                <input type="text" class="form-control" name="year" maxlength="4" placeholder="Select Year" required="required"> 
                                <span class="input-group-addon">
                                    <i class="font-icon font-icon-calend"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <!--<label class="form-control-label">Classes</label>-->
                        <div class="form-group">
                            <select class="form-control select_class" required name="class" onchange="getStudentMarks(this)">
                                <option value="">Select Class</option>
                                <?php 
                                foreach ($classes as $c) { ?>
                                <option value="<?php echo $c->classid;?>"><?php echo $c->class_name;?></option>
                                <?php }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <!--<label class="form-control-label">Months</label>-->
                        <div class="form-group">
                            <select class="form-control select_exam" required name="exam" onchange="getStudentMarks(this)">
                                <option value="" data-key="" data-term="" data-format="">Select Exam</option>
                                <?php 
                                foreach ($exams as $e) { ?>
                                <option value="<?php echo $e->id;?>" data-key="<?php echo $e->key;?>" data-term="<?php echo $e->term;?>" data-format="<?php echo $e->format;?>"><?php echo $e->name;?></option>
                                <?php }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                    	<!--<label class="form-control-label">Sections</label>-->
                        <div class="form-group">
                            <select class="form-control select_section" required name="section" onchange="getStudentMarks(this)">
                                <option value="">Select Section</option>
                                <?php 
                                foreach ($sections as $s) { ?>
                                <option value="<?php echo $s->sectionid;?>"><?php echo $s->section_name;?></option>
                                <?php }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                    	<!--<label class="form-control-label">Subjects</label>-->
                        <div class="form-group">
                            <select class="form-control select_subject select2" required name="subject[]" multiple="multiple" onchange="getStudentMarks(this)">
                                <option value="">Select Subject</option>
                                <?php 
                                foreach ($subjects as $s) { ?>
                                <option value="<?php echo $s->subjectid;?>"><?php echo $s->subject_name;?></option>
                                <?php }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <!--<label class="form-control-label">Teachers</label>-->
                        <div class="form-group">
                            <select class="form-control select_teacher" required name="teacher" onchange="getStudentMarks(this)">
                                <option value="">Select Class Teacher</option>
                                <?php 
                                foreach ($teachers as $t) { ?>
                                <option value="<?php echo $t->teacherid;?>"><?php echo $t->teacher_name;?></option>
                                <?php }
                                ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="clearfix">&nbsp;</div>
                <div class="row">
                	<div class="col-sm-12 table-responsive" id="students_container">
                    </div>
                </div>
                <div class="clearfix">&nbsp;</div>
                <!--<div class="row">
                    <div class="col-sm-12 text-center">
                        <input type="submit" class="btn btn-success" value="Submit"/>
                    </div>
                </div>-->                    
            </form>                        
            </div>
        </div>
    </section>
</div><!--.container-fluid-->
<script>
$(document).ready(function() {
	$('.datetimepicker-year').datetimepicker({
		viewMode: 'years',
		format: 'YYYY'
	}).on('dp.change', function (e) {
        getStudentMarks();
    });
})

function getStudentMarks()
{
	var year = $("input[name='year']").val();
	var exam = $("select[name='exam']").val();
	var classid = $("select[name='class']").val();
	var section = $("select[name='section']").val();
	var subject = $("select[name='subject']").val();
	var teacher = $("select[name='teacher']").val();
	var exam_key = $("select[name='exam']").find(':selected').data('key');
	var exam_term = $("select[name='exam']").find(':selected').data('term');
	var exam_format = $("select[name='exam']").find(':selected').data('format');
	if(exam_key == "")var exam_key = "first_term_quiz";if(exam_term == "")var exam_term = "first";if(exam_format == "")var exam_format = "quiz";
	$.ajax({
		type: 'POST',
		dataType:'json',
		url: '<?php echo base_url()."admin/marksheet/getStudentMarks";?>',
		data: {year:year,classid:classid,section:section,exam:exam,subject:subject,teacher:teacher},
		success: function(students)
		{
			console.log(students);
			var html = '';
			var colspan = 3;
			var total_given_marks = "";
			var exam_marks_display = "none";
			/*var first_term_quiz = false;
			var first_term_exam = false;
			var second_term_quiz = false;
			var second_term_exam = false;
			if(exam_key == "first_term_quiz"){var colspan = 3;var first_term_quiz = true;}
			if(exam_key == "first_term_exam"){var colspan = 4;var first_term_exam = true;}
			if(exam_key == "second_term_quiz"){var colspan = 3;var second_term_quiz = true;}
			if(exam_key == "second_term_exam"){var colspan = 3;var second_term_exam = true;}*/
			if(exam_format == "exam"){var colspan = 4;var exam_marks_display = "table-cell";}
			if(students)
			{
				html += '<table border="0" cellspacing="0" cellpadding="0" class="table table-stripped table-bordered">';
				html += '	<thead>';
				/*html += '		<tr><th style="text-align:center">Subjects</th><th style="text-align:center" rowspan="3">Total Marks</th><th  style="text-align:center" rowspan="3">Obtained Marks</th><th style="text-align:center" rowspan="3">Percentage</th><th style="text-align:center" rowspan="3">GR No</th></tr>';*/
				count = 0;
				$.each(students, function(i, student) {
					if(count == 0)
					{
					html += '		<tr>';
					html += '			<th class="text-center" width="5%">Actions</th>';
					html += '			<th class="no-height no-border-bottom text-center" width="8%">GR No</th>';
					html += '			<th class="no-padding no-margin">';
					html += '			<div class="table-responsive">';
					html += '				<table border="0" cellspacing="0" cellpadding="0" class="table no-padding no-border no-margin">';
					html += '					<tr>';
					$.each(student, function(i, subject) {
					html += '						<td class="no-padding no-border no-margin">';
					html += '							<table border="0" cellspacing="0" cellpadding="0" class="table no-margin">';				
					html += '								<thead>';
					html += '								<tr><th class="no-border-top no-border-right no-height no-border-bottom  no-border-right text-center" colspan="'+colspan+'">'+subject.subject_name+'</th></tr>';
					html += '								<tr>';
					html += '									<th class="no-height no-border-bottom no-border-right text-center" width="30%">Q&nbsp;</th>';
					html += '									<th class="no-height no-border-bottom no-border-right text-center" width="30%">CW</th>';
					html += '									<th class="no-height no-border-bottom no-border-right text-center" width="40%" style="display:'+exam_marks_display+'">TM</th>';
					html += '									<th class="no-height no-border-bottom no-border-right text-center" width="40%">T&nbsp;</th>';
					html += '								</tr>';
					html += '								<thead>';
					html += '							</table>';
					html += '						</td>';
					});
					html += '					</tr>';
					html += '				</table>';
					html += '			</div>';
					html += '			</th>';
					html += '			<th class="no-height no-border-bottom text-center">Total Marks</th>';
					html += '			<th class="no-height no-border-bottom text-center">Obtained Marks</th>';
					html += '			<th class="no-height no-border-bottom text-center">Percentage</th>';
					//html += '			<th class="no-height no-border-bottom text-center">GR No</th>';
					html += '		</tr>';
					}
					count++;
				});
				html += '	</thead>';
				
				html += '	<tbody>';
				
				$.each(students, function(i, student) {
					student_data = student[Object.keys(student)[0]];
					html += '		<tr id="row'+i+'">';
					html += '			<td class="text-center"><input type="button" class="btn btn-default" value="Generate" onclick="generateResultCard('+student_data.year+','+student_data.exam+','+student_data.classid+','+student_data.section+','+student_data.student+','+student_data.teacher+')"/></td>';
					html += '			<td class="no-height text-center">'+student_data.GR_number+'</td>';
					html += '			<td class="no-padding no-border no-margin no-height no-border-bottom">';
					html += '			<div class="table-responsive">';
					html += '				<table border="0" cellspacing="0" cellpadding="0" class="table no-padding no-border no-margin">';
					html += '					<tr>';
					total_total_marks = 0;
					total_obtained_marks = 0;
					$.each(student, function(i, subject) {
					exam_marks = 0;
					total_marks = 0;
					questions_marks = 0;
					obtained_marks = 0;
					class_work_marks = 0;
					questions_total_marks = 0;
					class_work_total_marks = 0;
					first_term_total_marks = 0;
					exam_max_marks = 0;
					exam_passing_marks = 0;
					questions_max_marks = 0;
					questions_passing_marks = 0;
					class_work_max_marks = 0;
					class_work_passing_marks = 0;
					if(subject.stdid != null)studentid = subject.stdid;
					if(subject.mark_id != null)mark_id = subject.mark_id;
					if(subject.GR_number != null)gr_number = subject.GR_number;
					/*if(subject.total_marks != null)
					{
						total_marks = subject.total_marks;
						questions_total_marks = subject.total_marks;
						class_work_total_marks = subject.total_marks;
						first_term_total_marks = subject.total_marks;
					}*/
					
					/*if(subject.exam_marks != null)exam_marks = subject.exam_marks;
					if(subject.questions_marks != null)questions_marks = subject.questions_marks;
					if(subject.class_work_marks != null)class_work_marks = subject.class_work_marks;*/
					
					if(exam_term == "first")
					{
						if(subject.first_term_exam_marks != null)exam_marks = subject.first_term_exam_marks;
						if(subject.first_term_exam_max_marks != null)exam_max_marks = subject.first_term_exam_max_marks;
						if(subject.first_term_exam_passing_marks != null)exam_passing_marks = subject.first_term_exam_passing_marks;
						if(subject.first_term_questions_marks != null)questions_marks = subject.first_term_questions_marks;
						if(subject.first_term_questions_max_marks != null)questions_max_marks = subject.first_term_questions_max_marks;
						if(subject.first_term_questions_passing_marks != null)questions_passing_marks = subject.first_term_questions_passing_marks;
						if(subject.first_term_class_work_marks != null)class_work_marks = subject.first_term_class_work_marks;
						if(subject.first_term_class_work_max_marks != null)class_work_max_marks = subject.first_term_class_work_max_marks;
						if(subject.first_term_class_work_passing_marks != null)class_work_passing_marks = subject.first_term_class_work_passing_marks;
					}
					else
					{
						if(subject.second_term_exam_marks != null)exam_marks = subject.second_term_exam_marks;
						if(subject.second_term_exam_max_marks != null)exam_max_marks = subject.second_term_exam_max_marks;
						if(subject.second_term_exam_passing_marks != null)exam_passing_marks = subject.second_term_exam_passing_marks;
						if(subject.second_term_questions_marks != null)questions_marks = subject.second_term_questions_marks;
						if(subject.second_term_questions_max_marks != null)questions_max_marks = subject.second_term_questions_max_marks;
						if(subject.second_term_questions_passing_marks != null)questions_passing_marks = subject.second_term_questions_passing_marks;
						if(subject.second_term_class_work_marks != null)class_work_marks = subject.second_term_class_work_marks;
						if(subject.second_term_class_work_max_marks != null)class_work_max_marks = subject.second_term_class_work_max_marks;
						if(subject.second_term_class_work_passing_marks != null)class_work_passing_marks = subject.second_term_class_work_passing_marks;
					}
					
					if(exam_format == "quiz")
					{
						obtained_marks = parseFloat(parseFloat(questions_marks)+parseFloat(class_work_marks));
						total_marks = parseFloat(parseFloat(questions_max_marks)+parseFloat(class_work_max_marks));
					}
					else
					{
						obtained_marks = parseFloat(parseFloat(questions_marks)+parseFloat(class_work_marks)+parseFloat(exam_marks));
						total_marks = parseFloat(parseFloat(questions_max_marks)+parseFloat(class_work_max_marks)+parseFloat(exam_max_marks));
					}
					//total_marks = parseFloat(parseFloat(questions_total_marks)+parseFloat(class_work_total_marks));
					total_total_marks = parseFloat(total_total_marks) + parseFloat(total_marks);
					total_obtained_marks = parseFloat(total_obtained_marks) + parseFloat(obtained_marks);
					html += '						<td class="no-padding no-border no-margin no-height no-border-bottom no-border-right">';
					html += '							<table border="0" cellspacing="0" cellpadding="0" class="table no-margin">';				
					/*if(count == 0)
					{
					html += '								<thead>';
						html += '								<tr><th style="text-align:center" class="no-border-top no-border-right no-height" colspan="3">'+subject.subject_name+'</th></tr>';
						html += '								<tr>';
						html += '									<th style="text-align:center" class="no-height">Q</th>';
						html += '									<th style="text-align:center" class="no-height">CW</th>';
						html += '									<th style="text-align:center" class="no-height">T</th>';
						html += '								</tr>';
					html += '								<thead>';
					}*/
					html += '								<tr>';
					if(questions_marks == 0)
					html += '									<td class="no-height no-border-bottom text-center" width="30%">00</td>';
					else
					html += '									<td class="no-height no-border-bottom text-center" width="30%">'+Math.abs(questions_marks)+'</td>';
					if(class_work_marks == 0)
					html += '									<td class="no-height no-border-bottom text-center" width="30%">00</td>';
					else
					html += '									<td class="no-height no-border-bottom text-center" width="30%">'+Math.abs(class_work_marks)+'</td>';
					if(exam_marks == 0)
					html += '									<td class="no-height no-border-bottom text-center" width="30%" style="display:'+exam_marks_display+'">00</td>';
					else
					html += '									<td class="no-height no-border-bottom text-center" width="30%" style="display:'+exam_marks_display+'">'+Math.abs(exam_marks)+'</td>';
					html += '									<td class="no-height no-border-bottom text-center" width="40%">'+Math.abs(obtained_marks)+'</td>';
					html += '								</tr>';
					html += '							</table>';
					html += '						</td>';
					});
					html += '					</tr>';
					html += '				</table>';
					html += '			</div>';
					html += '			</td>';
					percentage = parseFloat(total_obtained_marks)*parseFloat(100)/parseFloat(total_total_marks);
					html += '			<td class="no-height text-center">'+Math.abs(total_total_marks)+'</td>';
					html += '			<td class="no-height text-center">'+Math.abs(total_obtained_marks)+'</td>';
					html += '			<td class="no-height text-center">'+percentage.toFixed(2)+'</td>';
					//html += '			<td class="no-height text-center">'+gr_number+'</td>';
					html += '		</tr>';
					count++;
				});
				html += '	</tbody>';
				html += '</table>';
			}
			else
			{
				html +='<p class="text-center">No students found</p>';
			}
			$("#students_container").html(html);
		},
	});
}

function generateResultCard(year,exam,classid,section,student,teacher)
{
	var search_year = $("input[name='year']").val();
	var search_exam = $("select[name='exam']").val();
	window.open ("<?php echo base_url().'admin/marksheet/generateMarkSheet';?>"+"/"+year+"/"+exam+"/"+classid+"/"+section+"/"+student+"/"+teacher+"/"+search_year+"/"+search_exam, "Student Mark Sheet","status=0,toolbar=0");
}
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.1/js/select2.min.js"></script>
<style>
.no-height
{
	/*height:auto !important;*/
}
.no-padding
{
	padding:0px !important;
}
.no-margin
{
	margin:0px !important;
}
.no-border
{
	border:0px !important;
}
.no-border-top
{
	border-top:0px !important;
}
.no-border-right
{
	border-right:0px !important;
}
.no-border-left
{
	border-left:0px !important;
}
.no-border-bottom
{
	border-bottom:0px !important;
}
.vertical-align-middle
{
	vertical-align:middle !important;
}

.select2-selection
{
	height:34px !important;
	border-radius:0px !important;
	min-height:34px !important;
	border-color:#ccc !important;
}
</style>