<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Student extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
	}

	// Frontend User CRUD
	public function index()
	{
		$crud = $this->generate_crud('students');
		$crud->columns(array('picture','PR_number','GR_number','name','classid','sectionid','nationality'));
		//$crud->add_fields('branchid','name','gender','picture','classid','sectionid','subject','GR_number','PR_number','email1','email2','student_password','mobile1','mobile2','address','nationality','religion','description','gps_location','dob','iqama_no','iqama_expiry','license_no','license_expiry','passport_no','passport_expiry','registration_date');
		//$crud->edit_fields('branchid','name','gender','picture','classid','sectionid','subject','GR_number','PR_number','email1','email2','student_password','mobile1','mobile2','address','nationality','religion','description','gps_location','dob','iqama_no','iqama_expiry','license_no','license_expiry','passport_no','passport_expiry','registration_date');
		$crud->set_field_upload('picture', UPLOAD_PICTURES);
		$crud->change_field_type('student_password','password');
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$crud->set_relation('branchid','branches','branch_name');
		$crud->set_relation('classid','classes','class_name');
		$crud->set_relation('sectionid','sections','section_name');
		
		$this->db->select('*');
		$querydata = $this->db->get('subjects')->result(); // to get whole table values

		$resultarray = array();  // defines a new array
		foreach ($querydata as $result) 
		{

			$resultarray[$result->subjectid] = $result->subject_name; //initializing table values to the array 

		}

		$crud->field_type('subject', 'multiselect', $resultarray);
		
		
		
		$this->mPageTitle = 'Students';
		$this->render_crud();
	}
}	