<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Marksheet extends Admin_Controller {

	public $data = array();
	public $layout = '_layouts/print';
	public function __construct() {
        parent::__construct();

        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('admin/MarkSheet_model', 'MarkSheetModel');
    }
	
	public function index()
	{
		$this->mViewData['months'] = $this->CommonModel->get_all_rows("months");
		$this->mViewData['classes'] = $this->CommonModel->get_all_rows("classes");
		$this->mViewData['teachers'] = $this->CommonModel->get_all_rows("teacher");
		$this->mViewData['subjects'] = $this->CommonModel->get_all_rows("subjects");
		$this->mViewData['sections'] = $this->CommonModel->get_all_rows("sections");
		$this->mViewData['exams'] = $this->CommonModel->get_all_rows("exams_types");
		$this->mViewData['message'] = $this->session->flashdata('message');
		$this->render('mark_sheet');
	}
	
	public function getStudentMarks()
	{
		$students = array();
		if(!empty($_POST))
		{
			$students_array = array();
			$students = $this->MarkSheetModel->get_student_marks($_POST);
			// Check if $students is a valid array
        	if (is_array($students)) {
				array_walk($students, function($val,$key) use(&$students_array){
					$students_array[$val->stdid][] = $val;
				});
			} 
		}
		//echo "<pre>";print_r($students_array);
		echo json_encode($students_array);
	}


	
	public function generateMarkSheet($year,$exam,$classid,$section,$student,$teacher,$search_year,$search_exam)
	{
		$request = array();
		$this->data['title'] = 'Mark Sheet | Print';
		$this->data['content'] = 'mark_sheet_print';
		$request['year'] = $this->data['year'] = $year;
		$request['exam'] = $this->data['exam'] = $exam;
		$request['classid'] = $this->data['classid'] = $classid;
		$request['section'] = $this->data['section'] = $section;
		$request['student'] = $this->data['student'] = $student;
		$request['teacher'] = $this->data['teacher'] = $teacher;
		$class = $this->data['class'] = $this->CommonModel->get_row("classes",$classid);//print_r($class);
		$exam = $this->data['exam'] = $this->CommonModel->get_row("exams_types",$search_exam);//print_r($exam);
		$teacher = $this->data['teacher'] = $this->CommonModel->get_row("teacher",$teacher);//print_r($teacher);
		$student = $this->data['student'] = $this->CommonModel->get_row("students",$student);//print_r($student);
		$section = $this->data['section'] = $this->CommonModel->get_row("sections",$section);//print_r($section);
		$principal = $this->data['principal'] = $this->MarkSheetModel->get_teacher_principal($teacher->branchid);//print_r($principal);
		$student_marks = $this->data['student_marks'] = $this->MarkSheetModel->get_student_marks($request);//print_r($this->data['student_marks']);
		$student_marks_row = $this->data['student_marks_row'] = $this->MarkSheetModel->get_student_marks_row($request);//print_r($this->data['student_marks_row']);
		$percentage_grades = $this->data['percentage_grades'] = $this->MarkSheetModel->get_percentage_grades($request);//print_r($this->data['percentage_grades']);
		$this->data['print_layout'] = ($exam->print_layout == 'A3')?'A3':'A4';
		$this->data['print_portrait'] = ($exam->print_portrait == 'landscape')?'landscape':'';
		$this->load->view($this->layout, $this->data);
	}
}