<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Fee extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
	}

	// Frontend User CRUD
	public function index()
	{
		$crud = $this->generate_crud('fee_history');
		$crud->columns(array('GR_number','classid','branchid','fee_id','type','amount','vat','discount','pay_status'));
		$crud->add_fields('GR_number','classid','branchid','fee_id','type','amount','vat','discount','month','duedate','paydate','pay_status');
		$crud->edit_fields('GR_number','classid','branchid','fee_id','type','amount','vat','discount','month','duedate','paydate','pay_status');
		$crud->set_relation('GR_number','students','GR_number');
		$crud->set_relation('fee_id','fee_structure','amount');
		$crud->set_relation('branchid','branches','branch_name');
		$crud->set_relation('classid','classes','class_name');
		$crud->display_as('fee_id','Amount');
		$crud->display_as('vat','Vat (5%)');
		$crud->change_field_type('vat', 'true_false',array('No','Yes'));
		$crud->change_field_type('pay_status', 'true_false',array('Not Paid','Paid'));
		$montharray = array();
		for ($month=0;$month<12;$month++) 
		{
			$montharray[$month+1] = date("F", strtotime("January +$month months"));
		}
		$crud->change_field_type('month', 'dropdown',$montharray);
		
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$this->mPageTitle = 'Fee';
		$this->render_crud();
	}
}	