<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class TakeStudentFee extends MY_Controller {

    public $site = 'Beladi International School | Accountant';
    public $layout = 'accountant/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
		
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
    }

    public function index() {
		$date = "";
		$month = "";
		$PR_number = "";
		$GR_number = "";
		$students = array();
		$students_fees = array();
		$months = $this->AccountantModel->getMonths();
		$parents = $this->AccountantModel->getAllParents();
		if($_POST)
		{
			$PR_number = $_POST['PR_number'];
			$GR_number = $_POST['GR_number'];
			$date = isset($_POST['date'])?$_POST['date']:'';
			$month = isset($_POST['month'])?$_POST['month']:'';
			$this->session->set_userdata('fee_voucher_date',$date);
			$this->session->set_userdata('fee_voucher_month',$month);
			$this->session->set_userdata('fee_voucher_pr_number',$PR_number);
			$this->session->set_userdata('fee_voucher_gr_number',$GR_number);
			//$students_fees = $this->AccountantModel->getStudentsFees($PR_number,$GR_number);
			$students_fees = $this->AccountantModel->getStudentsFees($_POST);
			if(!empty($PR_number))$students = $this->AccountantModel->getParentStudent($PR_number);
			//echo "<pre>";print_r($students_fees);
		}
		$this->data['date'] = $date;
		$this->data['month'] = $month;
		$this->data['months'] = $months;
		$this->data['parents'] = $parents;
		$this->data['students'] = $students;
		$this->data['GR_number'] = $GR_number;
		$this->data['PR_number'] = $PR_number;
		$this->data['students_fees'] = $students_fees;
		$this->data['content'] = 'take_student_fees';
		$this->load->view($this->layout, $this->data);
    }	
	
	public function getParentStudent()
	{
		$studentsArray = array();
		if(!empty($_POST['PR_number']))
		{
			$PR_number = $_POST['PR_number'];
			$students = $this->AccountantModel->getParentStudent($PR_number);
			foreach($students as $key=>$student)
			{
				$studentsArray[] = array("id"=>$student->stdid, "text"=>$student->GR_number);
				//$studentsArray[] = array("id"=>$student->stdid, "text"=>$student->GR_number." - ".$student->name);
			}
		}
		echo json_encode($studentsArray);
		
	}
	public function studentFeeVoucher($fee_history_id='')
	{
		$students_fees = "";
		$this->data['id'] = $fee_history_id;
		$this->data['date'] = $this->session->userdata('fee_voucher_date');
		$this->data['month'] = $this->session->userdata('fee_voucher_month');
		$this->data['PR_number'] = $this->session->userdata('fee_voucher_pr_number');
		$this->data['GR_number'] = $this->session->userdata('fee_voucher_gr_number');
		$parent = $this->AccountantModel->getParentByPR($this->data['PR_number']);
		//$students_fees = $this->AccountantModel->getStudentsFees($PR_number,$GR_number);
		$students_fees = $this->AccountantModel->getStudentsFees($this->data);
		$this->data['parent'] = $parent;//print_r($parent);
		$this->data['print_layout'] = 'A3';
		$this->data['print_portrait'] = 'landscape';
		$this->data['students_fees'] = $students_fees;
		$this->data['content'] = 'student_fees_voucher';
		$this->load->view('accountant/layout_print', $this->data);
	}
}