<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class StudentResults extends MY_Controller {

    public $site = 'Beladi International School | Accountant';
    public $layout = 'accountant/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
		
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
    }

    public function index() {
        $this->data['title'] = 'Student Results Cards | Home';
		$this->data['content'] = 'student_results';
		$this->data['students'] = $this->AccountantModel->getAllStudents();
		$this->data['exams_types'] = $this->AccountantModel->getExamsTypes();
        $this->load->view($this->layout, $this->data);
    }	
	public function cards($PR_number='',$GR_number='',$exams='')
	{
		$students_fees = "";
		$this->data['exams'] = $exams;
		$this->data['PR_number'] = $PR_number;
		$this->data['GR_number'] = $GR_number;
		$subjects = $this->AccountantModel->getAllSubjects();
		$parent = $this->AccountantModel->getParentByPR($PR_number);
		$student = $this->AccountantModel->getStudentByGR($GR_number);
		
		$this->data['parent'] = $parent[0];//print_r($parent);
		$this->data['student'] = $student[0];
		$this->data['subjects'] = $subjects;
		$this->data['print_portrait'] = 'landscape';
		$this->data['title'] = 'Student Results Cards | Home';
		$this->data['content'] = 'student_results_cards';
		$this->data['print_layout'] = ($exams == 'quiz')?'A4':'A3';
		$this->load->view('accountant/layout_print', $this->data);
	}
}