<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*class StudentFee extends MY_Controller {

    public $site = 'Beladi International School | Accountant';
    public $layout = 'accountant/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
    }

    public function index() {
        $this->data['title'] = 'Student Fee | Home';
		$this->data['content'] = 'student_fee';
		if($_POST)
		{
			$post['GR_number'] = $_POST['GR_number'];
			$post['amount'] = $_POST['amount'];
			$post['type'] = $_POST['type'];
			$post['vat'] = (isset($_POST['vat']))?1:0;
			$post['discount'] = $_POST['discount'];
			$post['paydate'] = date('Y-m-d',  strtotime($_POST['paydate']));
			$this->AccountantModel->addStudentfee($post); 
			$this->data['insert'] = 'yes';
		}
		$this->data['classes'] = $this->AccountantModel->getClasses();
		$this->data['students'] = $this->AccountantModel->getStudents();
		$this->data['fees'] = $this->AccountantModel->getMonthlyfee();
		$this->data['stdfee'] = $this->AccountantModel->getStudentfee();
		$this->data['branches'] = $this->AccountantModel->getAllBranches();
        $this->load->view($this->layout, $this->data);
    }	
	public function edit($id) {
        $this->data['title'] = 'Student Fee | Home';
		$this->data['content'] = 'studentfee_edit';
		if($_POST)
		{
			$post['classid'] = $_POST['classid'];
			$post['GR_number'] = $_POST['GR_number'];
			$post['paydate'] = date('Y-m-d',  strtotime($_POST['paydate']));
			$post['fee_id'] = $_POST['fee_id'];
			$this->AccountantModel->updateStudentfee($post,$id); 
			$this->data['insert'] = 'yes';
		}
		$this->data['classes'] = $this->AccountantModel->getClasses();
		$this->data['students'] = $this->AccountantModel->getStudents();
		$this->data['fees'] = $this->AccountantModel->getMonthlyfee();
		$this->data['stdfee'] = $this->AccountantModel->getStudentfee($id);
		$this->data['branches'] = $this->AccountantModel->getAllBranches();
        $this->load->view($this->layout, $this->data);
    }	
	public function getStudentinfo()
	{
		$stdid = $_POST['stdid'];
		$students = $this->AccountantModel->getStudentinfo($stdid);
		echo json_encode($students);
		
	}
	public function pendingStudentFee($date='')
	{
		$students = $this->AccountantModel->getStudentsinfo();
		if($students)
		{
			foreach ($students as $std)
			{
				$fee = $this->AccountantModel->pendingStudentFee($date,$std->GR_number);
				if($fee)
				{
					unset($std);
				}
			}
		}
		$this->data['students'] = $students;
		$this->data['content'] = 'pending_fee';
		$this->load->view($this->layout, $this->data);
	}
	public function takeStudentFee($date='')
	{
		$PR_number = "";
		$GR_number = "";
		$students_fees = "";
		$parents = $this->AccountantModel->getAllParents();
		if($_POST)
		{
			//$PR_number = $_POST['PR_number'];
			//$GR_number = $_POST['GR_number'];
			//$students_fees = $this->AccountantModel->getStudentsFees($PR_number,$GR_number);
			$students_fees = $this->AccountantModel->getStudentsFees($_POST);
		}
		$this->data['parents'] = $parents;
		$this->data['GR_number'] = $GR_number;
		$this->data['PR_number'] = $PR_number;
		$this->data['students_fees'] = $students_fees;
		$this->data['content'] = 'take_student_fees';
		$this->load->view($this->layout, $this->data);
	}
	public function getParentStudent()
	{
		$PR_number = $_POST['PR_number'];
		$students = $this->AccountantModel->getParentStudent($PR_number);
		echo json_encode($students);
		
	}
	public function studentFeeVoucher($PR_number='',$GR_number='')
	{
		$students_fees = "";
		$this->data['PR_number'] = $PR_number;
		$this->data['GR_number'] = $GR_number;
		$parent = $this->AccountantModel->getParentByPR($PR_number);
		$students_fees = $this->AccountantModel->getStudentsFees($PR_number,$GR_number);
		$this->data['parent'] = $parent;//print_r($parent);
		$this->data['students_fees'] = $students_fees;
		$this->data['content'] = 'student_fees_voucher';
		$this->load->view('accountant/layout_print', $this->data);
	}
}*/

class StudentFee extends Accountant_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
		
        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }

        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
	}

	// Frontend User CRUD
	public function index()
	{
		$crud = $this->generate_crud('fee_history');
		$crud->columns(array('GR_number','classid','branchid','fee_id','type','amount','vat','discount','pay_status'));
		$crud->add_fields('GR_number','classid','branchid','fee_id','type','amount','vat','discount','month','duedate','paydate','pay_status');
		$crud->edit_fields('GR_number','classid','branchid','fee_id','type','amount','vat','discount','month','duedate','paydate','pay_status');
		$crud->set_relation('GR_number','students','GR_number');
		$crud->set_relation('fee_id','fee_structure','amount');
		$crud->set_relation('classid','classes','class_name');
		$crud->set_relation('branchid','branches','branch_name');
		$crud->display_as('fee_id','Amount');
		$crud->display_as('vat','Vat (5%)');
		$crud->display_as('classid','Class Name');
		$crud->display_as('branchid','Branch Name');
		$crud->change_field_type('vat', 'true_false',array('No','Yes'));
		$crud->change_field_type('pay_status', 'true_false',array('Not Paid','Paid'));
		$montharray = array();
		for ($month=0;$month<12;$month++) 
		{
			$montharray[$month+1] = date("F", strtotime("January +$month months"));
		}
		$crud->change_field_type('month', 'dropdown',$montharray);
		$crud->callback_field('GR_number',array($this,'callback_GR_number'));
		$crud->callback_field('classid',array($this,'callback_classid'));
		$crud->callback_field('branchid',array($this,'callback_branchid'));
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$this->mPageTitle = 'Student Fee';
		$this->render_crud();
	}
	
	function callback_GR_number($value = null, $primary_key = null)
	{
	  //You can do it strait forward
	  $output = '<script>
	  			$(document).ready(function() {
					$("select[name=GR_number]").on("change", function () {
						var stdid = $(this).find(":selected").data("gr_number");
						$.ajax({
							type: "POST",
							dataType:"json",
							url: "'.base_url().'accountant/StudentFee/getStudentinfo",
							data: {stdid:stdid},
							success: function(data)
							{
								console.log(data);
								$("input[name=classid]").val(data.classid);
								$("input[name=class_name]").val(data.class_name);
								$("input[name=branchid]").val(data.branchid);
								$("input[name=branch_name]").val(data.branch_name);
							},
						});
					});
				});
				</script>';
	  		
	  $output .= '<select id="field-GR_number" name="GR_number" class="chosen-select" data-placeholder="Select GR number">';
	  $students = $this->CommonModel->get_all_rows('students');
	  //$students = $this->db->get_where('students',array('GR_number'=>$value))->result_array();
	  if($students)
	  {
		$output.='<option value="">Select GR number</option>';
		foreach ($students as $student)
		{
			$selected = ""; 
			if($student->stdid == $value)$selected = 'selected="selected"';
			$output.='<option value="'.$student->stdid.'" data-gr_number="'.$student->GR_number.'" '.$selected.'>'.$student->GR_number.' - '.$student->name.'</option>';
		}
	  }	
	  $output .= '</select>';
	  return $output;
	}
	
	function callback_classid($value = null, $primary_key = null)
	{
	  //You can do it strait forward
	  $class = $this->CommonModel->get_row("classes", $value);
	  $class_name = "";if(!empty($class))$class_name = $class->class_name;
	  $output = '<input id="field-classid" type="hidden" name="classid" value="'.$value.'"/>';
	  $output .= '<input type="text" name="class_name" value="'.$class_name.'" class="form-control" disabled="disabled"/>';
	  return $output;
	}
	
	function callback_branchid($value = null, $primary_key = null)
	{
	  //You can do it strait forward
	  $branch = $this->CommonModel->get_row("branches", $value);
	  $branch_name = "";if(!empty($branch))$branch_name = $branch->branch_name;
	  $output = '<input id="field-branchid" type="hidden" name="branchid" value="'.$value.'"/>';
	  $output .= '<input type="text" name="branch_name" value="'.$branch_name.'" class="form-control" disabled="disabled"/>';
	  return $output;
	}
	
	public function getStudentinfo()
	{
		$stdid = $_POST['stdid'];
		$students = $this->AccountantModel->getStudentinfo($stdid);
		echo json_encode($students);
		
	}
}	