<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class SetStudentFee extends MY_Controller {

    public $data = array();
	public $layout = 'accountant/layout';
	public $site = 'Beladi International School | Accountant';
	
	public function __construct()
	{
		parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
	}

	public function index()
	{
		$this->data['content'] = 'set_student_fees';
		$this->data['title'] = 'Set Student Fees | Home';		
		if($_POST)
		{
			$post['stdid'] = $_POST['GR_number'];
			$post['discount'] = $_POST['discount'];
			$post['fees_type_id'] = $_POST['fees_type_id'];
			$post['discount_amount'] = $_POST['discount_amount'];
			$post['discounted_fees_value'] = $_POST['discounted_fees_value'];
			$this->AccountantModel->setStudentFees($post);
			$this->data['save'] = 'yes';
		}
		$this->data['fees_type'] = $this->AccountantModel->getFeesType();
		$this->data['fees_value'] = $this->AccountantModel->getFeesValue();
		$this->data['students'] = $this->AccountantModel->getAllStudents();
		$this->data['student_fees'] = $this->AccountantModel->getStudentFees();
		$this->data['fees_type_reporting'] = $this->AccountantModel->getFeesTypeByCondition("reporting",1);
		if(!empty($this->session->flashdata('delete')))
		$this->data['delete'] = $this->session->flashdata('delete');
        $this->load->view($this->layout, $this->data);
	}
	
	public function edit($id)
	{
		$this->data['student_fee'] = $this->AccountantModel->getStudentFeesById($id);
		$this->data['content'] = 'set_student_fees_edit';
		$this->data['title'] = 'Edit Student Fees | Home';	
		$this->load->view($this->layout, $this->data);
	}
	
	public function delete($id)
	{
		$this->db->where('id',$id);
		$this->db->delete('students_fees_discounts');
		$this->session->set_flashdata('delete', 'yes');
		redirect('accountant/setStudentFee',$this->data);
	}
	
	public function getSetStudentFeesValueDetails()
	{
		$students = array();
		$stdid = $_POST['stdid'];
		if($stdid)
		{
			$selected_fees_type = array();
			$students = $this->AccountantModel->getSetStudentFeesValueDetails($stdid);
			$value = unserialize($students['value']);
			array_walk($value, function($val,$key) use(&$selected_fees_type){
				$fees_type = $this->AccountantModel->getFeesTypeByCondition("id",$key);
				if($fees_type[0]->reporting == 1)
				{
					$val['fees_type_name'] = $fees_type[0]->type;$selected_fees_type[$key] = $val;
				}
			});
			$students['value'] = $selected_fees_type;
		}
		echo json_encode($students);
	}
}	