<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Profile extends MY_Controller {

    public $site = 'Beladi International School | Accountant';
    public $layout = 'accountant/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        $this->data['profile'] = 'profile';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
        // Get Logged User
		$this->data['accountant_data'] = $this->CommonModel->get_row('accounts', $this->session->userdata('accountant_id')); 
    }

    public function index() {
        $this->data['title'] = 'Profile | Home';
		$this->data['content'] = 'profile';
        $this->load->view($this->layout, $this->data);
    }
}