<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class PendingFee extends MY_Controller {

    public $site = 'Beladi International School | Accountant';
    public $layout = 'accountant/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
    }

    public function index($date='') {
        $students = $this->AccountantModel->getStudentsinfo();
		if($students)
		{
			foreach ($students as $std)
			{
				$fee = $this->AccountantModel->pendingStudentFee($date,$std->GR_number);
				if($fee)
				{
					unset($std);
				}
			}
		}
		$this->data['students'] = $students;
		$this->data['content'] = 'pending_fee';
		$this->load->view($this->layout, $this->data);
    }	
}