<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PayStudentFee extends MY_Controller {

    public $data = array();
	public $layout = 'accountant/layout';
	public $site = 'Beladi International School | Accountant';
	
	public function __construct()
	{
		parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
		
		$settings_tuition_due_date = $this->CommonModel->getSettingByKey('tuition_due_date');
		$start_date = date("Y")."-01-01";$end_date = date("Y")."-".date("m")."-".$settings_tuition_due_date->value;
		$date_diff = abs(strtotime($end_date) - strtotime($start_date));$fees_number_of_years = floor($date_diff / (365*60*60*24));
		$this->data['fees_number_of_months'] = floor(($date_diff - $fees_number_of_years * 365*60*60*24) / (30*60*60*24));
	}

	public function index()
	{
		$post_search = array();
		$this->data['action'] = true;
		$this->data['content'] = 'pay_student_fees_listings';
		$this->data['title'] = 'Pay Student Fees | Home';		
		if($_POST)
		{
			if($_POST['action'] == "save")
			{
				$post['pay_status'] = 1;
				$post['id'] = $_POST['id'];
				$post['stdid'] = $_POST['GR_number'];
				$post['classid'] = $_POST['classid'];
				$post['sectionid'] = $_POST['sectionid'];
				$post['pay_amount'] = $_POST['pay_amount'];
				$post['fees_type_id'] = $_POST['fees_type_id'];
				$post['vat'] = (isset($_POST['vat']))?1:0;
				$post['pay_date'] = date('Y-m-d',  strtotime($_POST['pay_date']));
				$id = $this->AccountantModel->addStudentFees($post);
				$this->data['save'] = ($post['id'])?"updated":"added";
				$this->session->set_flashdata('save', ($post['id'])?"updated":"added");
				//echo json_encode(array("status"=>1,"id"=>$id));				
				//exit();
				redirect('accountant/payStudentFee',$this->data);
			}
			
			if($_POST['action'] == "search")
			{
				$post_search['status'] = $_POST['status'];
				$post_search['classid'] = $_POST['classid'];
				$post_search['to_date'] = $_POST['to_date'];
				$post_search['from_date'] = $_POST['from_date'];
				$post_search['PR_number'] = $_POST['PR_number'];
				$post_search['GR_number'] = $_POST['GR_number'];
				$post_search['sectionid'] = $_POST['sectionid'];
			}
		}
		
		$this->data['post_search'] = $post_search;
		$this->data['classes'] = $this->AccountantModel->getClasses();
		$this->data['parents'] = $this->AccountantModel->getAllParents();
		$this->data['fees_type'] = $this->AccountantModel->getFeesType();
		$this->data['fees_value'] = $this->AccountantModel->getFeesValue();
		$this->data['students'] = $this->AccountantModel->getAllStudents();		
		$this->data['sections'] = $this->AccountantModel->getAllSections();
		$this->data['student_payments'] = $this->AccountantModel->getStudentPayments($post_search);
		//$settings_tuition_due_date = $this->CommonModel->getSettingByKey('tuition_due_date');
		//$start_date = date("Y")."-01-01";$end_date = date("Y")."-".date("m")."-".$settings_tuition_due_date->value;
		//$date_diff = abs(strtotime($end_date) - strtotime($start_date));$fees_number_of_years = floor($date_diff / (365*60*60*24));
		//$this->data['fees_number_of_months'] = floor(($date_diff - $fees_number_of_years * 365*60*60*24) / (30*60*60*24));
		if(!empty($this->session->flashdata('save')))
		$this->data['save'] = $this->session->flashdata('save');
		if(!empty($this->session->flashdata('delete')))
		$this->data['delete'] = $this->session->flashdata('delete');
        $this->load->view($this->layout, $this->data);
	}
	
	public function add()
	{
		$this->data['content'] = 'pay_student_fees';
		$this->data['title'] = 'Pay Student Fees | Home';		
		/*if($_POST)
		{
			$post['pay_status'] = 1;
			$post['id'] = $_POST['id'];
			$post['stdid'] = $_POST['GR_number'];
			$post['classid'] = $_POST['classid'];
			$post['sectionid'] = $_POST['sectionid'];
			$post['pay_amount'] = $_POST['pay_amount'];
			$post['fees_type_id'] = $_POST['fees_type_id'];
			$post['pay_date'] = date('Y-m-d',  strtotime($_POST['pay_date']));
			$test = $this->AccountantModel->addStudentFees($post);
			$this->data['save'] = 'yes';
		}*/
		$this->data['months'] = $this->AccountantModel->getMonths();
		$this->data['fees_type'] = $this->AccountantModel->getFeesType();
		$this->data['fees_value'] = $this->AccountantModel->getFeesValue();
		$this->data['students'] = $this->AccountantModel->getAllStudents();
		$this->data['student_fees'] = $this->AccountantModel->getStudentFees();
		//$this->data['student_payments_sum'] = $this->AccountantModel->getStudentPaymentsSum();
		$this->data['fees_type_reporting'] = $this->AccountantModel->getFeesTypeByCondition("reporting",1);
		$settings_tuition_due_date = $this->CommonModel->getSettingByKey('tuition_due_date');
		$start_date = date("Y")."-01-01";$end_date = date("Y")."-".date("m")."-".$settings_tuition_due_date->value;
		$date_diff = abs(strtotime($end_date) - strtotime($start_date));$fees_number_of_years = floor($date_diff / (365*60*60*24));
		$this->data['fees_number_of_months'] = floor(($date_diff - $fees_number_of_years * 365*60*60*24) / (30*60*60*24));
        $this->load->view($this->layout, $this->data);
	}
	
	public function edit($id)
	{
		$students_payments_sum = "";
		$this->data['months'] = $this->AccountantModel->getMonths();
		$this->data['student_payment'] = $student_payment = $this->AccountantModel->getStudentPaymentsById($id);
		if($student_payment && isset($student_payment['stdid']))
		{	
			$stdid = $student_payment['stdid'];
			$students_payments_sum = $this->AccountantModel->getStudentPaymentsSum($stdid);
		}
		$this->data['students_payments_sum'] = $students_payments_sum;
		$this->data['content'] = 'pay_student_fees_edit';
		$this->data['title'] = 'Edit Pay Fees | Home';	
		$this->load->view($this->layout, $this->data);
	}
	
	public function view($id)
	{
		$students_payments_sum = "";
		$this->data['months'] = $this->AccountantModel->getMonths();
		$this->data['student_payment'] = $student_payment = $this->AccountantModel->getStudentPaymentsById($id);
		if($student_payment && isset($student_payment['stdid']))
		{	
			$stdid = $student_payment['stdid'];
			$students_payments_sum = $this->AccountantModel->getStudentPaymentsSum($stdid);
		}
		$this->data['students_payments_sum'] = $students_payments_sum;
		$this->data['content'] = 'pay_student_fees_view';
		$this->data['title'] = 'View Pay Fees | Home';	
		$this->load->view($this->layout, $this->data);
	}
	
	public function receipt($id)
	{
		$this->data['student_payment'] = $student_payment = $this->AccountantModel->getStudentPaymentsById($id);
		//echo "<pre>";print_r($student_payment);
		$this->data['title'] = 'Pay Fees Receipt';
		$this->data['print_layout'] = 'A4';
		$this->data['print_portrait'] = 'landscape';
		$this->data['content'] = 'pay_student_fees_receipt';	
		$this->load->view('accountant/layout_print', $this->data);
	}
	
	public function delete($id)
	{
		$this->db->where('id',$id);
		$this->db->delete('students_fees_discounts');
		$this->session->set_flashdata('delete', 'yes');
		redirect('accountant/setStudentFee',$this->data);
	}
	
	public function getAddStudentFeesDetails()
	{
		$students = array();
		$stdid = $_POST['stdid'];
		if($stdid)
		{
			/*$selected_fees_type = array();
			$students = $this->AccountantModel->getAddStudentFeesDetails($stdid);
			$students_payments_sum = $this->AccountantModel->getStudentPaymentsSum($stdid);
			$value = unserialize($students['value']);
			array_walk($value, function($val,$key) use(&$selected_fees_type,$stdid){
				$fees_type = $this->AccountantModel->getFeesTypeByCondition("id",$key);
				if($fees_type[0]->reporting == 1)
				{
					$cond = array("stdid"=>$stdid,"fees_type_id"=>$val['fees_type_id']);
					$student_fees = $this->AccountantModel->getStudentFeesByCondition($cond);
					if($student_fees)
					{
						$val['fees_type_discount'] = $student_fees['discount'];
						//$fees_type_discount = $val['fees_type_value']*$val['fees_type_discount']/100;
						//$val['fees_type_value'] = $val['fees_type_value'] - $fees_type_discount;
						$val['fees_type_value'] = $student_fees['discounted_fees_value'];
					}
					$val['fees_type_name'] = $fees_type[0]->type;$selected_fees_type[$key] = $val;
				}
			});
			$students['value'] = $selected_fees_type;
			$students['pay_amount'] = $students_payments_sum['pay_amount'];*/
			$students = $this->getAddStudentFeesDetailsData($stdid);
		}
		echo json_encode($students);
	}
	
	public function getAddStudentFeesDetailsData($stdid)
	{
		if($stdid)
		{
			$selected_fees_type = array();
			$students = $this->AccountantModel->getAddStudentFeesDetails($stdid);
			$students_payments_sum = $this->AccountantModel->getStudentPaymentsSum($stdid);
			$value = unserialize($students['value']);
			array_walk($value, function($val,$key) use(&$selected_fees_type,$stdid){
				$fees_type = $this->AccountantModel->getFeesTypeByCondition("id",$key);
				if($fees_type[0]->reporting == 1)
				{
					$cond = array("stdid"=>$stdid,"fees_type_id"=>$val['fees_type_id']);
					$student_fees = $this->AccountantModel->getStudentFeesByCondition($cond);
					if($student_fees)
					{
						$val['fees_type_discount'] = $student_fees['discount'];
						//$fees_type_discount = $val['fees_type_value']*$val['fees_type_discount']/100;
						//$val['fees_type_value'] = $val['fees_type_value'] - $fees_type_discount;
						$val['fees_type_value'] = $student_fees['discounted_fees_value'];
					}
					$val['fees_type_name'] = $fees_type[0]->type;$selected_fees_type[$key] = $val;
				}
			});
			$students['value'] = $selected_fees_type;
			$students['pay_amount'] = $students_payments_sum['pay_amount'];
		}
		return $students;
	}
	
	// for generate pdf
	public function save_pdf()
	{ 
    	//load mPDF library
    	$this->load->library('m_pdf'); 
   
   		//now pass the data//
		$this->data['action'] = false;
		$post_search['status'] = $_POST['status'];
		$post_search['classid'] = $_POST['classid'];
		$post_search['to_date'] = $_POST['to_date'];
		$post_search['from_date'] = $_POST['from_date'];
		$post_search['PR_number'] = $_POST['PR_number'];
		$post_search['GR_number'] = $_POST['GR_number'];
		$post_search['sectionid'] = $_POST['sectionid'];
		$this->data['student_payments'] = $this->AccountantModel->getStudentPayments($post_search);
   		$html = $this->load->view("accountant/pay_student_fees_listings_pdf", $this->data,true); //load the pdf.php by passing our data and get all data in $html varriable.
   		$pdfFilePath ="webpreparations-".time().".pdf"; 
   		//actually, you can pass mPDF parameter on this load() function
   		$pdf = $this->m_pdf->load();
   		//generate the PDF!
		$stylesheet = '<style>'.file_get_contents(base_url().'assets/grocery_crud/themes/bootstrap/css/bootstrap/bootstrap.min.css').'</style>';
		$stylesheet .= '<style>'.file_get_contents(base_url().'assets/grocery_crud/themes/bootstrap/css/bootstrap/bootstrap.min.css').'</style>';
   		// apply external css
   		$pdf->WriteHTML($stylesheet,1);
   		$pdf->WriteHTML($html,2);
   		//offer it to user via browser download! (The PDF won't be saved on your server HDD)
   		$pdf->Output($pdfFilePath, "D");
   		exit;
	}
}	