<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FeesType extends Accountant_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
		
        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }

        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
	}

	// Frontend User CRUD
	public function index()
	{
		$crud = $this->generate_crud('fees_type');
		$crud->columns(array('type','period'));
		$crud->add_fields('type','period');
		$crud->edit_fields('type','period');
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$this->mPageTitle = 'Fees Type';
		$this->render_crud();
	}
}	