<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FeeHistory extends Accountant_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
		
        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }

        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
	}

	// Frontend User CRUD
	public function index()
	{
		$crud = $this->generate_crud('fee_history');
		
		$crud->set_relation('GR_number','students','GR_number');
		$crud->set_relation('fee_id','fee_structure','amount');
		$crud->set_relation('classid','classes','class_name');
		$crud->set_relation('branchid','branches','branch_name');
		$crud->display_as('fee_id','Amount');
		$crud->display_as('vat','Vat (5%)');
		$crud->change_field_type('vat', 'enum',array('No','Yes'));
		$crud->change_field_type('pay_status', 'enum',array('Not Paid','Paid'));
		
		/*$crud->callback_add_field('type', function () {
            return '<input type="text" maxlength="50" value="" name="phone" style="width:462px">';
        });*/
		/*$crud->callback_add_field('type', function ($value, $primary_key) {
            return '+30 <input type="text" maxlength="50" value="'.$value.'" name="phone" style="width:462px">';
        });*/
		$crud->unset_bootstrap();
		$crud->unset_jquery();
		$this->mPageTitle = 'Student Fee';
		$this->render_crud();
	}
	
	public function getStudentinfo()
	{
		$stdid = $_POST['stdid'];
		$students = $this->AccountantModel->getStudentinfo($stdid);
		echo json_encode($students);
		
	}
}	