<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Wtimetable_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function get_wtimetable($teacherid)
	{
		$this->db->select("dayid,d.name as dayname");
        $this->db->where('w.teacherid', $teacherid);
		$this->db->join('days as d', 'w.dayid=d.id');
         $query = $this->db->get('weekly_timetable w');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	function get_wtimetablebyday($dayid, $teacherid)
	{
		$this->db->select("l.*,c.class_name,s.section_name,sb.subject_name");
        $this->db->where('teacherid', $teacherid);
		$this->db->where('dayid', $dayid);
		$this->db->order_by('period_no', 'ASC');
		$this->db->join('classes as c', 'c.classid=l.classid');
		$this->db->join('sections as s', 's.sectionid=l.sectionid');
		$this->db->join('subjects as sb', 'sb.subjectid=l.subjectid');
         $query = $this->db->get('weekly_timetable as l');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getallstarttime($teacherid)
	{
		$this->db->select("start_time");
		$this->db->distinct();
        $this->db->where('w.teacherid', $teacherid);
		$this->db->order_by('w.period_no', 'ASC');
        $query = $this->db->get('weekly_timetable w');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getallperiods($teacherid)
	{
		$this->db->select("period_no");
		$this->db->distinct();
        $this->db->where('w.teacherid', $teacherid);
		$this->db->order_by('w.period_no', 'ASC');
        $query = $this->db->get('weekly_timetable w');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function add($post)
	{
		$post['teacherid']=$this->session->userdata('teacher_id');
		$post['date']=date('Y-m-d');
		$this->db->set($post);
        $insert = $this->db->insert("teacher_submitted_complaints");
        return $this->db->insert_id();
	}
}

?>
